# Windsurf Rules Configuration

This directory contains modular Windsurf rules for the Telepay Laravel project, organized for better maintainability and clarity.

## Structure

```
.windsurf/
├── rules.yml                 # Main aggregator file
└── rules.d/                  # Modular rule files
    ├── 00-core.yml           # Core philosophy
    ├── 10-php-style.yml      # PSR standards & PHP style
    ├── 20-typing.yml         # Type declarations
    ├── 30-docblocks.yml      # Documentation blocks
    ├── 40-constructors-traits.yml # Constructor promotion & traits
    ├── 50-control-flow.yml   # If statements & flow control
    ├── 60-whitespace.yml     # Code formatting & spacing
    ├── 70-config.yml         # Laravel configuration
    ├── 80-artisan.yml        # Artisan commands
    ├── 90-routing.yml        # Web routing
    ├── 95-api.yml            # API design
    ├── 100-controllers.yml   # Controller patterns
    ├── 110-views-blade.yml   # Blade templating
    ├── 120-validation.yml    # Form validation
    ├── 130-authorization.yml # Policies & gates
    ├── 140-translations.yml  # Internationalization
    ├── 150-naming.yml        # Naming conventions
    └── 160-laravel-best.yml  # Laravel best practices
```

## Usage

The main `rules.yml` file includes all modular rules using the `include` directive. If your Windsurf version doesn't support includes, you can concatenate all files from `rules.d/` into a single file.

## Rule Categories

### Core & Style (00-60)
- **Core Philosophy**: Laravel documentation adherence
- **PHP Style**: PSR compliance, enums, string handling
- **Typing**: Nullable types, void returns, typed properties
- **Docblocks**: When and how to document code
- **Constructors & Traits**: Modern PHP patterns
- **Control Flow**: If statements, early returns
- **Whitespace**: Code formatting guidelines

### Laravel Configuration (70-80)
- **Config**: Environment variables, caching
- **Artisan**: Command naming, feedback, generators

### Routing & APIs (90-95)
- **Routing**: URL conventions, route model binding
- **API**: RESTful design, versioning, rate limiting

### Application Layer (100-160)
- **Controllers**: Naming, responsibility separation
- **Views & Blade**: Template organization
- **Validation**: Form requests, custom rules
- **Authorization**: Policies, gates, CSRF
- **Translations**: Localization helpers
- **Naming**: Class and method conventions
- **Laravel Best Practices**: Framework-specific patterns

## Customization

To modify rules:
1. Edit the appropriate file in `rules.d/`
2. Add new rule files following the numbering convention
3. Update `rules.yml` to include new files

## Integration with Development Workflow

The rules are designed to work alongside the enhanced Composer scripts for common Laravel workflows. See the main project README for available scripts.
