
0) Executive Summary
   •	What it is: A Telegram-first storefront for lawful digital products (templates, courses, scripts, keys you own, API credits, support bundles).
   •	How users pay: Users deposit BTC to a unique address per deposit request (BitGo). When confirmed, we convert to USD using the captured rate at confirmation and credit the user’s USD balance.
   •	How users buy: Users spend their USD balance to purchase products inside Telegram. Fulfillment is instant (download link/key/instructions).
   •	Admin: Staff uses Filament 4 to manage catalog, orders, deposits, customers, and support.

⸻

1) Functional Requirements

1.1 Roles
•	Customer (Telegram user)
•	Start bot, see main menu
•	View balance (USD)
•	Create a deposit request → get unique BTC address + QR
•	After confirmations, balance credited in USD
•	Browse categories → subcategories → product list → product detail
•	Buy products using USD balance
•	View purchase history & re-access entitlements
•	Read rules and contact support
•	Admin/Staff (Filament)
•	Manage categories/subcategories (tree)
•	Manage products (title, price_usd, optional balance value included by the product, stock, warnings, delivery payload)
•	Moderate listings (active/inactive)
•	View/create/adjust deposits (with audit)
•	Handle orders, reissue or revoke entitlements, refunds to balance
•	Adjust user balances (with audit & permissions)
•	View reports (revenue, deposits, top products)
•	Manage support tickets

1.2 Customer Flows (Telegram)
•	Onboarding (/start)
•	Greet → Buttons: Browse, Deposit, Balance, My Purchases, Support, Rules
•	Balance
•	Show Your balance: $X.XX
•	Deposit
•	Create Deposit Request → Generate unique BTC address via BitGo; show address + QR + instructions (confirmations required)
•	Mark deposit request open until a transaction is detected
•	When BitGo webhook indicates confirmations ≥ threshold, capture BTC→USD rate, credit USD to user balance, mark request used
•	Browse
•	Show top-level categories as buttons
•	Select a category → show subcategories
•	Select a subcategory → paginated product list
•	Select a product → product detail: title, price_usd, optional balance (if product includes usable credit), short_desc, warnings, delivery type
•	Buttons: Buy, Back
•	Buy
•	If balance_usd >= price_usd: create order (paid), decrement balance, create entitlement, send fulfillment
•	Else prompt to Deposit
•	My Purchases
•	List latest orders; open to show entitlements (link/key/text) again
•	Support
•	Show handle/group, instructions, open ticket
•	Rules
•	Show ToS/acceptable use/refund policy/legality reminders

⸻

2) Non-Functional Requirements
   •	Legal/Compliance: Only lawful goods; content moderation workflow; takedown process; ToS, AUP, Refund policy.
   •	Security: Encrypt sensitive payloads; verify BitGo webhooks; role-based admin; audit trail; rate limiting; CSRF exemption for webhooks with signature checks.
   •	Reliability: Idempotent deposit crediting; transactional balance updates; queue heavy work; retries for webhooks.
   •	Performance: Cache category trees & product lists; paginate; queue notifications.
   •	Observability: Structured logs, Sentry/Bugsnag, Horizon for queues, deposit reconciliation job.
   •	Backups: Daily DB & storage; tested restore docs.
   •	Environments: Separate dev/test/prod; BitGo testnet in non-prod.

⸻

3) Data Model (ERD Overview)

Users (1)──(∞) DepositRequests (1)──(∞) Deposits
Categories self-referential (parent/child) (1)──(∞) Products
Users (1)──(∞) Orders (1)──(∞) OrderItems (1)──(1) Entitlements

3.1 Tables & Columns

users
•	id (PK)
•	name (nullable)
•	telegram_id (unique, string)
•	username (nullable)
•	email (nullable)
•	role (enum/string: user, staff, owner)
•	balance_usd DECIMAL(14,2) DEFAULT 0.00
•	kyc_level TINYINT DEFAULT 0
•	timestamps

Indexes: (telegram_id unique), (role), (kyc_level)

categories
•	id (PK)
•	name (string)
•	slug (unique)
•	description (text, nullable)
•	parent_id (nullable, FK → categories.id)
•	is_active (bool, default true)
•	sort_order (int, default 0)
•	timestamps

Indexes: (slug unique), (parent_id), (is_active, sort_order)

products
•	id (PK)
•	category_id (FK → categories.id)
•	sku (unique, nullable)
•	title (string)
•	price_usd DECIMAL(12,2)
•	balance DECIMAL(14,2) nullable  ← if product includes usable credit/units
•	short_desc (text, nullable)
•	long_desc (text, nullable)
•	is_active (bool, default true)
•	stock_qty (int nullable; null = infinite)
•	delivery_type (enum/string: download|key|text|manual; default download)
•	delivery_payload (json, nullable)  ← encrypted at app layer
•	warnings (text nullable)
•	tags (json nullable)
•	timestamps

Indexes: (category_id, is_active), (sku), (title)

deposit_requests
•	id (PK)
•	user_id (FK → users.id)
•	provider (string default ‘bitgo’)
•	chain (string default ‘btc’)
•	address (unique, string)  ← unique per request
•	label (nullable)
•	status (string: open|used|expired|canceled; default open)
•	expires_at (nullable)
•	metadata (json nullable)
•	timestamps

Indexes: (user_id, status), (address unique)

deposits
•	id (PK)
•	user_id (FK → users.id)
•	deposit_request_id (FK → deposit_requests.id)
•	txid (unique, string)
•	address (string)
•	amount_satoshi (unsigned bigint)
•	confirmations (unsigned int default 0)
•	rate_usd_per_btc DECIMAL(18,8) nullable
•	credited_usd DECIMAL(14,2) nullable
•	status (string: pending|confirmed|failed|expired; default pending)
•	detected_at (timestamp nullable)
•	credited_at (timestamp nullable)
•	metadata (json nullable)
•	timestamps

Indexes: (user_id, status), (deposit_request_id), (address), (txid unique)

orders
•	id (PK)
•	user_id (FK → users.id)
•	total_usd DECIMAL(14,2)
•	status (string: pending|paid|fulfilled|refunded|canceled; default pending)
•	timestamps

Indexes: (user_id, status)

order_items
•	id (PK)
•	order_id (FK → orders.id)
•	product_id (FK → products.id)
•	qty (int default 1)
•	unit_price_usd DECIMAL(12,2)
•	line_total_usd DECIMAL(14,2)
•	snapshot (json)  ← copy of product display data at sale time
•	timestamps

Indexes: (order_id), (product_id)

entitlements
•	id (PK)
•	user_id (FK → users.id)
•	order_item_id (FK → order_items.id)
•	product_id (FK → products.id)
•	fulfillment_payload (json, encrypted)
•	expires_at (nullable)
•	redeemed_at (nullable)
•	timestamps

Indexes: (user_id), (order_item_id unique), (product_id)

support_tickets (optional)
•	id (PK)
•	user_id (FK)
•	subject (string)
•	status (open|pending|closed)
•	channel (string: telegram)
•	assigned_to (admin user id, nullable)
•	timestamps

audits (optional using spatie/laravel-activitylog or custom)
•	id (PK)
•	actor_type, actor_id
•	action (string)
•	target_type, target_id
•	diff (json)
•	timestamps

⸻

4) State Machines

Deposit Request
•	open → used (first successful confirmed deposit)
•	open → expired (by cron if past expires_at)
•	open → canceled (admin action)

Deposit
•	pending (detected but not enough confirmations)
•	confirmed (confirmations ≥ threshold; credited_usd set; immutable)
•	failed (invalid, double spend, or manual intervention)
•	expired (older than N days with no confirmations)

Order
•	pending (reserved if ever used; optional)
•	paid (balance deducted)
•	fulfilled (entitlement created & delivered)
•	refunded (to USD balance)
•	canceled (before fulfillment)

In our simple flow, we mark paid and fulfill immediately; optionally set fulfilled afterward.

⸻

5) Telegram Bot Specification

5.1 Commands
•	/start → main menu inline keyboard
•	/balance
•	/deposit
•	/browse
•	/purchases
•	/support
•	/rules

(You can implement only /start and handle the rest via buttons if preferred.)

5.2 Inline Keyboards & callback_data

Use short, parseable payloads:
•	Categories
•	cat:{id}:{page}
•	Subcategories
•	sub:{id}:{page}
•	Product
•	prd:{id}
•	Buy
•	buy:{id}
•	Balance
•	bal
•	Deposit (create new request)
•	dep:new
•	Purchases
•	pur:{page}

5.3 Message Copy (examples)

Welcome (/start)

Welcome to ToolStore — lawful digital downloads, API credits & support bundles.
What do you want to do?
[Browse] [Deposit] [Balance] [My Purchases] [Support] [Rules]

Balance

Your balance is $0.00.
[Deposit] [Back]

Deposit (new request)

Send BTC to this address. You’ll be credited in USD after 2 confirmations at the market rate at that time.
Address: bc1q...
[Show QR] [I’ve Paid] [Back]
(Include QR image with a bitcoin URI.)

Product detail

{title} — $XX.XX
{short_desc}
What to know: {warnings or “—”}
Delivery: {download/key/text/manual}
[Buy] [Back]

Buy (success)

✅ Purchase successful. ${price} deducted.
Your item: {link or key or text}.
[My Purchases] [Browse]

Insufficient funds

You need ${missing} more.
[Deposit] [Back]

Rules

Lawful goods only; no reselling credentials or other people’s data. All items moderated. Refunds for non-delivery only, per policy. Misuse → ban.

⸻

6) API & Backend Endpoints

6.1 Telegram Webhook
•	POST /bot/webhook (CSRF exempt)
•	Verify secret token (Telegram “secret token” header) if configured.
•	Parse message or callback_query.
•	Route to handlers.

Handlers
•	handleStart() → send main menu
•	handleBalance() → pull users.balance_usd
•	handleDeposit() → create deposit_requests + BitGo address; respond with address & QR
•	handleBrowse() → categories/subcategories/products
•	handleProductDetail(product_id) → return detail + Buy
•	handleBuy(product_id) → transactional purchase flow
•	handlePurchases(page) → recent orders & entitlements
•	handleSupport() → support info
•	handleRules() → rules text

6.2 BitGo Webhook
•	POST /webhooks/bitgo (CSRF exempt)
•	Verify BitGo signature (HMAC).
•	Parse payload: txid, address, value (sats), confirmations.
•	Find open deposit_requests by address.
•	Upsert deposits row for txid.
•	If confirmations < threshold → update confirmations → 200 OK.
•	If ≥ threshold:
•	In a DB transaction:
•	If not yet credited:
•	Pull BTC→USD rate (RateService::btcUsd()), round down to cents
•	Update deposits (status=confirmed, rate, credited_usd, credited_at)
•	Increment users.balance_usd by credited_usd
•	Mark deposit_requests.status = used
•	Dispatch NotifyUserDepositCredited

Idempotency: guard on deposits.credited_usd IS NULL before credit.

⸻

7) Services & Components

7.1 BitGoService (wrapper)
•	createAddress(label: string): string → returns BTC address
•	verifyWebhook(Request $req): bool
•	parseTx(Request $req): array { txid, address, value_sats, confirmations }

(Use BitGo testnet in dev)

7.2 RateService
•	btcUsd(): string → e.g., "64321.25"
•	Implementation: call a reputable rate source periodically (cron) and cache; or call on demand (with timeout & fallback). Store the exact rate used in deposits.rate_usd_per_btc.

7.3 QRService
•	generateBitcoinQr(address, optionalAmountBtc): path/to/png (using bacon/bacon-qr-code or endroid/qr-code)

7.4 PurchaseService
•	purchase(User $user, Product $product): Order
•	Transaction:
•	Check balance
•	Create order + order_item
•	Decrement balance_usd
•	Create entitlement (encrypt payload)
•	Dispatch SendEntitlement job to Telegram (or immediate send)

⸻

8) Admin (Filament 4) Specification

8.1 Panels & Permissions
•	Roles via spatie/laravel-permission:
•	owner: all
•	ops: deposits, orders, users (no role changes)
•	editor: categories/products only
•	analyst: read-only reports

8.2 Resources

UsersResource
•	Table: name, telegram_id, username, email, balance_usd, created_at
•	Actions:
•	Adjust balance (requires owner/ops; logs audit entry)
•	Ban/unban (status if you add)
•	View orders & deposits relationship managers

CategoriesResource
•	Fields: name, slug (auto), description, parent, is_active, sort_order
•	Tree view or parent selector
•	Toggle active

ProductsResource
•	Fields: category, title, price_usd, balance (optional), short_desc, long_desc, is_active, stock_qty, delivery_type, delivery_payload (file or JSON), warnings, tags
•	Table: title, category, price_usd, balance, stock, active
•	Actions: Activate/Deactivate, Duplicate, Approve (optional status), Force Fulfill (resend entitlement)

DepositRequestsResource
•	Table: id, user, address, status, created_at, expires_at
•	Actions: Cancel, Mark expired

DepositsResource
•	Table: id, user, request_id, txid (link to explorer), amount_satoshi, confirmations, credited_usd, rate_usd_per_btc, status, detected_at, credited_at
•	Actions: Mark failed, Manual credit/adjust (owner/ops only, audited)

OrdersResource
•	Table: id, user, total_usd, status, created_at
•	Relation manager: order_items (qty, price, snapshot)
•	Actions: Refund to balance (with reason), Reissue entitlement, Cancel (if not fulfilled)

EntitlementsResource
•	Table: id, user, product, created_at, expires_at, redeemed_at
•	Action: Resend delivery

Reports (custom pages)
•	Revenue (USD) by day
•	Confirmed deposits by day
•	Top products
•	Low stock

⸻

9) Security & Compliance
   •	Only lawful products. Create a “moderation required” flag before is_active=true.
   •	Encrypt delivery_payload & entitlements.fulfillment_payload with Laravel Crypt.
   •	Do not store 3rd-party credentials or personal data of others.
   •	Webhook security: verify BitGo signature, rate limit endpoint, log raw payload securely.
   •	Idempotency: all webhooks safe to retry.
   •	Admin audit trail: record who did what, with before/after diffs.
   •	2FA for owner/admin (Filament plugin or custom).
   •	Rounding rule: when crediting deposits in USD, round down to cents to avoid over-credit.

⸻

10) Error Handling & Edge Cases
    •	Deposit request created but no tx ever arrives → after expires_at, mark expired; user can create a new one.
    •	Multiple incoming txs to same address (overpayment/late payment):
    •	If request is still open, credit once per unique txid (each creates a deposit row). After first confirmed credit, mark request used.
    •	If additional txs come after used, treat based on policy:
    •	Option A: credit them and keep request used (i.e., a request can link multiple deposits)
    •	Option B: reject/flag for manual review.
    (Choose A for simplicity—allow multiple deposits to same request; the link ensures attribution.)
    •	BitGo webhook duplicates → handled by txid unique + idempotent credit guard.
    •	Insufficient balance on buy: respond with “need $X more” and Deposit button.
    •	Product out of stock at purchase time: block with friendly message.

⸻

11) Currency & Rate Capture
    •	Products priced in USD (price_usd)
    •	User balances in USD (balance_usd)
    •	Deposits store:
    •	amount_satoshi
    •	rate_usd_per_btc (at confirmation time)
    •	credited_usd = floor((sats / 100_000_000) * rate, 2)
    •	Display BTC and fiat info in UI only as informational approximations when needed.

⸻

12) Implementation Steps (Milestones)

M1: Core scaffold
•	Laravel 12 project; Redis (queues/cache); Filament 4; spatie/permission; activity log
•	Migrations for users, categories, products, deposit_requests, deposits, orders, order_items, entitlements
•	Seed: owner account, sample categories/products

M2: Telegram bot
•	Webhook endpoint
•	/start, main menu, balance, browse (categories→products)
•	Product detail & pagination

M3: Deposits
•	Deposit Request creation (per request BitGo address)
•	BitGo webhook endpoint + signature verify
•	Confirmations logic, rate capture, USD credit, Telegram notify

M4: Purchases
•	Buy flow (transactional), entitlement generation, Telegram delivery
•	Purchases list & re-delivery

M5: Admin (Filament)
•	Resources: Users, Categories, Products, DepositRequests, Deposits, Orders, Entitlements
•	Actions: balance adjustments (audited), approve/deactivate products, refund/reissue

M6: Ops & QA
•	Horizon, Sentry/Bugsnag, logging, backup scripts
•	E2E tests: deposit→credit→purchase
•	Deployment hardening

⸻

13) Tech Choices & Packages
    •	Laravel 12
    •	Filament 4
    •	Redis (cache/queue)
    •	Queues: Horizon
    •	Auth: Telegram id + app’s users table
    •	Permissions: spatie/laravel-permission
    •	Audit: spatie/laravel-activitylog (or custom)
    •	QR: bacon/bacon-qr-code or endroid/qr-code
    •	HTTP Client: Laravel HTTP for BitGo & rates
    •	Env vars (sample):

APP_NAME=ToolsStore
APP_ENV=production
APP_KEY=base64:...
DB_CONNECTION=mysql
QUEUE_CONNECTION=redis
CACHE_DRIVER=redis

TELEGRAM_BOT_TOKEN=xxxx:yyyy
TELEGRAM_WEBHOOK_SECRET=shhhh

BITGO_API_KEY=...
BITGO_WEBHOOK_SECRET=...
PAYMENTS_REQUIRED_CONFIRMATIONS=2

RATE_PROVIDER=coingecko // or your choice
RATE_API_KEY=...



⸻

14) Testing Strategy
    •	Unit
    •	USD rounding down helper; RateService returns numeric strings
    •	PurchaseService: success & insufficient funds
    •	Feature
    •	Webhook: BitGo → creates/updates deposit; at ≥ confirmations → credits USD; idempotency
    •	Telegram handlers: browse, product detail, buy
    •	E2E (happy path)
    •	Create deposit request → simulate tx detection → simulate N confirmations → balance increases → buy product → entitlement delivered
    •	Edge
    •	Duplicate webhooks; late confirmations; expired deposit requests; product inactive at buy

⸻

15) Acceptance Criteria (Go/No-Go)
    1.	Deposit
          •	Creating a deposit request returns a unique BTC address and QR in Telegram.
          •	When BitGo reports ≥ N confirmations, user balance increases in USD using the stored rate.
          •	The same webhook re-delivery does not double-credit.
    2.	Browse & Buy
          •	Users can navigate categories → subcategories → products; view product title, price_usd, balance (if set), warnings.
          •	Buying with sufficient balance deducts USD, creates order & entitlement, and delivers payload via Telegram immediately.
    3.	Admin
          •	Staff can add/edit products, set price_usd, optional balance, activate/deactivate; changes reflect in bot.
          •	Staff can view deposits, orders, users, and adjust balances with audit logs.
    4.	Security
          •	BitGo webhooks require a valid signature; invalid requests are rejected.
          •	Delivery payloads are encrypted at rest.
    5.	Reliability
          •	Queue failures are visible in Horizon; retries succeed; system is idempotent for webhooks and purchases.

⸻

16) Example Telegram Payloads & Callbacks

Callback: prd:42 → Product Detail Response (Markdown/HTML escaped)

Super Template Pack — $29.99
• 120+ components, lifetime updates
What to know: License for 1 user.
Delivery: instant download
[Buy] [Back]

Callback: buy:42 → Success

✅ Purchase successful. $29.99 deducted.
Download: https://signed.example.com/dl/abc123?exp=...

Callback: dep:new → Deposit Request Created

Deposit with Bitcoin (credited in USD after 2 confirmations)
Address: bc1qxyz...
[Show QR] [I’ve Paid] [Back]


⸻

17) Developer Notes & Conventions
    •	Codegen & structure
    •	Use php artisan make:model ... -m for models & migrations
    •	Controllers: BotWebhookController, BitgoWebhookController
    •	Services: BitgoService, RateService, QrService, PurchaseService
    •	Jobs: NotifyUserDepositCredited, SendEntitlement, CreditDeposit (if you split)
    •	Policies for admin resources if needed
    •	Transactions
    •	Deposit crediting & purchases must be wrapped in DB transactions.
    •	Money math
    •	Use strings + bc* math for BTC amounts; store satoshis as integers; convert to USD then floor to cents before credit.
    •	Env-driven settings
    •	Confirmations required; deposit expiry window; rate provider; explorer base URL.
    •	Content safety
    •	Add a required “Moderation approved” toggle before product becomes active.

⸻


