<?php

declare(strict_types=1);

namespace App\Actions\Telegram;

use App\Bot\Data\TelegramCallbackData;
use App\Models\Category;
use App\Models\User;
use App\Services\TelegramService;
use App\Traits\HasBotTranslations;

class BrowseProductsAction
{
    use HasBotTranslations;

    public function __construct(
        private TelegramService $telegram
    ) {}

    public function execute(TelegramCallbackData $callback): void
    {
        $user = User::where('telegram_id', (string)$callback->from->id)->first();
        $lang = $user?->language ?? 'ru';
        
        $categories = Category::whereNull('parent_id')
            ->where('is_active', true)
            ->orderBy('sort_order')
            ->get();

        $text = __('bot.browse_categories', [], $lang) . "\n\n" . __('bot.select_category', [], $lang);

        $buttons = [];
        foreach ($categories as $category) {
            $buttons[] = [
                ['text' => $category->name, 'callback_data' => "cat:{$category->id}:0"],
            ];
        }

        $buttons[] = [
            ['text' => __('bot.home', [], $lang), 'callback_data' => 'menu'],
        ];

        $keyboard = $this->telegram->createInlineKeyboard($buttons);

        $this->telegram->editMessageText(
            $callback->message->chat->id,
            $callback->message->message_id,
            $text,
            $keyboard
        );
    }
}
