<?php

declare(strict_types=1);

namespace App\Actions\Telegram;

use App\Bot\Data\TelegramMessageData;
use App\Bot\Messages\BalanceMessage;
use App\Models\User;
use App\Services\TelegramService;

class ProcessBalanceCommand
{
    public function __construct(
        private TelegramService $telegram
    ) {}

    public function execute(TelegramMessageData $message): void
    {
        $user = User::where('telegram_id', (string)$message->from->id)->first();

        if (!$user) {
            return;
        }

        $lang = $user->language ?? 'ru';
        $text = BalanceMessage::show($user);
        
        $keyboard = $this->telegram->createInlineKeyboard([
            [
                ['text' => __('bot.deposit_btc', [], $lang), 'callback_data' => 'dep:new'],
                ['text' => __('bot.history_button', [], $lang), 'callback_data' => 'history'],
            ],
            [
                ['text' => __('bot.home', [], $lang), 'callback_data' => 'menu'],
            ],
        ]);

        $this->telegram->sendMessage($message->chat->id, $text, $keyboard);
    }
}
