<?php

declare(strict_types=1);

namespace App\Actions\Telegram;

use App\Bot\Data\TelegramMessageData;
use App\Models\User;
use App\Services\TelegramService;
use App\Traits\HasBotTranslations;

class ProcessHelpCommand
{
    use HasBotTranslations;

    public function __construct(
        private TelegramService $telegram
    ) {}

    public function execute(TelegramMessageData $message): void
    {
        $user = User::where('telegram_id', (string)$message->from->id)->first();
        $lang = $user?->language ?? 'ru';
        $general = app(\App\Settings\GeneralSettings::class);
        
        $text = __('bot.help_text', ['support' => $general->support_username], $lang);

        $keyboard = $this->telegram->createInlineKeyboard([
            [
                ['text' => __('bot.home', [], $lang), 'callback_data' => 'menu'],
            ],
        ]);

        $this->telegram->sendMessage($message->chat->id, $text, $keyboard);
    }
}
