<?php

declare(strict_types=1);

namespace App\Actions\Telegram;

use App\Bot\Data\TelegramMessageData;
use App\Bot\Messages\HistoryMessage;
use App\Models\User;
use App\Services\TelegramService;

class ProcessHistoryCommand
{
    public function __construct(
        private TelegramService $telegram
    ) {}

    public function execute(TelegramMessageData $message): void
    {
        $user = User::where('telegram_id', (string)$message->from->id)->first();

        if (!$user) {
            return;
        }

        $lang = $user->language ?? 'ru';
        $text = HistoryMessage::show($user);
        
        $keyboard = $this->telegram->createInlineKeyboard([
            [
                ['text' => __('bot.balance_button', [], $lang), 'callback_data' => 'bal'],
                ['text' => __('bot.deposit', [], $lang), 'callback_data' => 'dep:new'],
            ],
            [
                ['text' => __('bot.home', [], $lang), 'callback_data' => 'menu'],
            ],
        ]);

        $this->telegram->sendMessage($message->chat->id, $text, $keyboard);
    }
}
