<?php

declare(strict_types=1);

namespace App\Actions\Telegram;

use App\Bot\Data\TelegramCallbackData;
use App\Bot\Messages\BalanceMessage;
use App\Models\User;
use App\Services\TelegramService;

class ShowBalanceAction
{
    public function __construct(
        private TelegramService $telegram
    ) {}

    public function execute(TelegramCallbackData $callback): void
    {
        $user = User::where('telegram_id', (string)$callback->from->id)->first();

        if (!$user) {
            return;
        }

        $lang = $user->language ?? 'ru';
        $text = BalanceMessage::show($user);
        
        $keyboard = $this->telegram->createInlineKeyboard([
            [
                ['text' => __('bot.deposit_btc', [], $lang), 'callback_data' => 'dep:new'],
                ['text' => __('bot.history_button', [], $lang), 'callback_data' => 'history'],
            ],
            [
                ['text' => __('bot.home', [], $lang), 'callback_data' => 'menu'],
            ],
        ]);

        $this->telegram->editMessageText(
            $callback->message->chat->id,
            $callback->message->message_id,
            $text,
            $keyboard
        );
    }
}
