<?php

declare(strict_types=1);

namespace App\Actions\Telegram;

use App\Bot\Data\TelegramCallbackData;
use App\Models\User;
use App\Services\TelegramService;
use App\Traits\HasBotTranslations;

class ShowLanguageSelectionAction
{
    use HasBotTranslations;

    public function __construct(
        private TelegramService $telegram
    ) {}

    public function execute(TelegramCallbackData $callback): void
    {
        $user = User::where('telegram_id', $callback->from->id)->first();
        $lang = $user?->language ?? 'ru';

        $text = __('bot.select_language', [], $lang);

        $buttons = [
            [
                ['text' => __('bot.language_english', [], 'en'), 'callback_data' => 'lang:en'],
            ],
            [
                ['text' => __('bot.language_russian', [], 'ru'), 'callback_data' => 'lang:ru'],
            ],
            [
                ['text' => __('bot.back', [], $lang), 'callback_data' => 'menu'],
            ],
        ];

        $keyboard = $this->telegram->createInlineKeyboard($buttons);

        $this->telegram->editMessageText(
            $callback->message->chat->id,
            $callback->message->message_id,
            $text,
            $keyboard
        );
    }

    public function setLanguage(TelegramCallbackData $callback, string $languageCode): void
    {
        $user = User::where('telegram_id', $callback->from->id)->first();

        if (!$user) {
            return;
        }

        $user->language = $languageCode;
        $user->save();

        $text = __('bot.language_updated', [], $languageCode);

        $buttons = [
            [
                ['text' => __('bot.main_menu', [], $languageCode), 'callback_data' => 'menu'],
            ],
        ];

        $keyboard = $this->telegram->createInlineKeyboard($buttons);

        $this->telegram->editMessageText(
            $callback->message->chat->id,
            $callback->message->message_id,
            $text,
            $keyboard
        );
    }
}
