<?php

declare(strict_types=1);

namespace App\Bot\Data;

use Spatie\LaravelData\Attributes\MapInputName;
use Spatie\LaravelData\Data;

class TelegramUserData extends Data
{
    public function __construct(
        public int $id,
        #[MapInputName('first_name')]
        public ?string $firstName = null,
        #[MapInputName('username')]
        public ?string $username = null,
        #[MapInputName('last_name')]
        public ?string $lastName = null,
    ) {}
}
