<?php

declare(strict_types=1);

namespace App\Bot\Messages;

use App\Models\User;
use App\Models\Deposit;
use App\Models\Order;
use App\Models\DepositRequest;

class BalanceMessage
{
    public static function show(User $user): string
    {
        $lang = $user->language ?? 'ru';
        
        $totalDeposits = Deposit::where('user_id', $user->id)
            ->where('status', 'confirmed')
            ->sum('credited_usd');
        
        $totalSpent = Order::where('user_id', $user->id)
            ->where('status', 'paid')
            ->sum('total_usd');
        
        $pendingDeposits = DepositRequest::where('user_id', $user->id)
            ->where('status', 'open')
            ->count();

        $text = __('bot.your_balance', [], $lang) . "\n\n";
        $text .= __('bot.current_balance_display', ['balance' => $user->balance_usd], $lang) . "\n\n";
        $text .= __('bot.statistics', [], $lang) . "\n";
        $text .= __('bot.total_deposited', ['amount' => $totalDeposits], $lang) . "\n";
        $text .= __('bot.total_spent', ['amount' => $totalSpent], $lang) . "\n";
        
        if ($pendingDeposits > 0) {
            $text .= "\n" . __('bot.pending_deposits', ['count' => $pendingDeposits], $lang) . "\n";
        }

        return $text;
    }
}
