<?php

declare(strict_types=1);

namespace App\Bot\Messages;

use App\Models\User;
use App\Models\Deposit;
use App\Models\Order;
use App\Services\BitGoService;

class HistoryMessage
{
    public static function show(User $user): string
    {
        $lang = $user->language ?? 'ru';
        
        $deposits = Deposit::where('user_id', $user->id)
            ->where('status', 'confirmed')
            ->orderBy('credited_at', 'desc')
            ->take(5)
            ->get();
        
        $orders = Order::where('user_id', $user->id)
            ->where('status', 'paid')
            ->orderBy('created_at', 'desc')
            ->take(5)
            ->get();

        $text = __('bot.transaction_history', [], $lang) . "\n\n";
        
        if ($deposits->isNotEmpty()) {
            $text .= __('bot.recent_deposits', [], $lang) . "\n";
            foreach ($deposits as $deposit) {
                $btc = BitGoService::satoshisToBtc($deposit->amount_satoshi);
                $date = $deposit->credited_at->format('M d, H:i');
                $text .= "• {$btc} BTC → \${$deposit->credited_usd} ({$date})\n";
            }
            $text .= "\n";
        }
        
        if ($orders->isNotEmpty()) {
            $text .= __('bot.recent_purchases', [], $lang) . "\n";
            foreach ($orders as $order) {
                $date = $order->created_at->format('M d, H:i');
                $text .= "• \${$order->total_usd} ({$date})\n";
            }
            $text .= "\n";
        }
        
        if ($deposits->isEmpty() && $orders->isEmpty()) {
            $text .= __('bot.no_transactions', [], $lang) . "\n\n";
            $text .= __('bot.start_with_deposit', [], $lang);
        }

        return $text;
    }
}
