<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\TelegramService;

class SetTelegramWebhook extends Command
{
    protected $signature = 'telegram:set-webhook {url?}';
    protected $description = 'Set Telegram bot webhook URL';

    public function handle()
    {
        $url = $this->argument('url') ?? config('app.url') . '/api/webhooks/telegram';
        $secret = config('services.telegram.webhook_secret');

        if (!config('services.telegram.bot_token')) {
            $this->error('TELEGRAM_BOT_TOKEN not configured in .env');
            return 1;
        }

        $this->info('Setting webhook to: ' . $url);

        $telegram = new TelegramService();
        $result = $telegram->setWebhook($url, $secret);

        if ($result['ok'] ?? false) {
            $this->info('✅ Webhook set successfully!');
            $this->info('URL: ' . $url);
            if ($secret) {
                $this->info('Secret token: Configured');
            }
            return 0;
        } else {
            $this->error('❌ Failed to set webhook');
            $this->error('Response: ' . json_encode($result));
            return 1;
        }
    }
}
