<?php

namespace App\Filament\Resources\DepositRequests;

use App\Filament\Resources\DepositRequests\Pages\CreateDepositRequest;
use App\Filament\Resources\DepositRequests\Pages\EditDepositRequest;
use App\Filament\Resources\DepositRequests\Pages\ListDepositRequests;
use App\Filament\Resources\DepositRequests\Schemas\DepositRequestForm;
use App\Filament\Resources\DepositRequests\Tables\DepositRequestsTable;
use App\Models\DepositRequest;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class DepositRequestResource extends Resource
{
    protected static ?string $model = DepositRequest::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;

    public static function form(Schema $schema): Schema
    {
        return DepositRequestForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return DepositRequestsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListDepositRequests::route('/'),
            'create' => CreateDepositRequest::route('/create'),
            'edit' => EditDepositRequest::route('/{record}/edit'),
        ];
    }
}
