<?php

namespace App\Filament\Resources\DepositRequests\Schemas;

use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Schemas\Schema;

class DepositRequestForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('user_id')
                    ->relationship('user', 'name')
                    ->required(),
                TextInput::make('provider')
                    ->required()
                    ->default('bitgo'),
                TextInput::make('chain')
                    ->required()
                    ->default('btc'),
                TextInput::make('address')
                    ->required(),
                TextInput::make('label'),
                TextInput::make('status')
                    ->required()
                    ->default('open'),
                DateTimePicker::make('expires_at'),
                Textarea::make('metadata')
                    ->columnSpanFull(),
            ]);
    }
}
