<?php

namespace App\Filament\Resources\Deposits\Schemas;

use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Schemas\Schema;

class DepositForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('user_id')
                    ->relationship('user', 'name')
                    ->required(),
                Select::make('deposit_request_id')
                    ->relationship('depositRequest', 'id')
                    ->required(),
                TextInput::make('txid')
                    ->required(),
                TextInput::make('address')
                    ->required(),
                TextInput::make('amount_satoshi')
                    ->required()
                    ->numeric(),
                TextInput::make('confirmations')
                    ->required()
                    ->numeric()
                    ->default(0),
                TextInput::make('rate_usd_per_btc')
                    ->numeric(),
                TextInput::make('credited_usd')
                    ->numeric(),
                TextInput::make('status')
                    ->required()
                    ->default('pending'),
                DateTimePicker::make('detected_at'),
                DateTimePicker::make('credited_at'),
                Textarea::make('metadata')
                    ->columnSpanFull(),
            ]);
    }
}
