<?php

namespace App\Filament\Resources\Deposits\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class DepositsTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('user.name')
                    ->searchable(),
                TextColumn::make('depositRequest.id')
                    ->searchable(),
                TextColumn::make('txid')
                    ->searchable(),
                TextColumn::make('address')
                    ->searchable(),
                TextColumn::make('amount_satoshi')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('confirmations')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('rate_usd_per_btc')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('credited_usd')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('status')
                    ->searchable(),
                TextColumn::make('detected_at')
                    ->dateTime()
                    ->sortable(),
                TextColumn::make('credited_at')
                    ->dateTime()
                    ->sortable(),
                TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->recordActions([
                EditAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
