<?php

namespace App\Filament\Resources\ParentCategories\Pages;

use App\Filament\Resources\ParentCategories\ParentCategoryResource;
use Filament\Actions\DeleteAction;
use Filament\Resources\Pages\EditRecord;

class EditParentCategory extends EditRecord
{
    protected static string $resource = ParentCategoryResource::class;

    protected function getHeaderActions(): array
    {
        return [
            DeleteAction::make(),
        ];
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        // Ensure parent_id remains null for parent categories
        $data['parent_id'] = null;
        
        return $data;
    }
}
