<?php

namespace App\Filament\Resources\ProductReports;

use App\Filament\Resources\ProductReports\Pages\CreateProductReport;
use App\Filament\Resources\ProductReports\Pages\EditProductReport;
use App\Filament\Resources\ProductReports\Pages\ListProductReports;
use App\Filament\Resources\ProductReports\Schemas\ProductReportForm;
use App\Filament\Resources\ProductReports\Tables\ProductReportsTable;
use App\Models\ProductReport;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class ProductReportResource extends Resource
{
    protected static ?string $model = ProductReport::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;

    protected static ?string $navigationLabel = 'Product Reports';
    
    protected static ?int $navigationSort = 1;

    public static function form(Schema $schema): Schema
    {
        return ProductReportForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return ProductReportsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListProductReports::route('/'),
            'create' => CreateProductReport::route('/create'),
            'edit' => EditProductReport::route('/{record}/edit'),
        ];
    }
}
