<?php

namespace App\Filament\Resources\ProductReports\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ViewAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Columns\BadgeColumn;
use Filament\Tables\Filters\SelectFilter;
use Filament\Tables\Table;

class ProductReportsTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('id')
                    ->label('Ticket #')
                    ->sortable()
                    ->searchable(),
                TextColumn::make('user.name')
                    ->label('User')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('product.title')
                    ->label('Product')
                    ->searchable()
                    ->limit(30),
                TextColumn::make('order.id')
                    ->label('Order #')
                    ->searchable(),
                BadgeColumn::make('status')
                    ->colors([
                        'warning' => 'pending',
                        'info' => 'under_review',
                        'success' => fn ($state) => in_array($state, ['approved', 'refunded']),
                        'danger' => 'denied',
                    ])
                    ->icons([
                        'heroicon-o-clock' => 'pending',
                        'heroicon-o-magnifying-glass' => 'under_review',
                        'heroicon-o-check-circle' => fn ($state) => in_array($state, ['approved', 'refunded']),
                        'heroicon-o-x-circle' => 'denied',
                    ]),
                TextColumn::make('refund_amount')
                    ->label('Amount')
                    ->money('usd')
                    ->sortable(),
                TextColumn::make('created_at')
                    ->label('Reported')
                    ->dateTime('M d, Y H:i')
                    ->sortable(),
                TextColumn::make('admin.name')
                    ->label('Handled By')
                    ->default('—'),
            ])
            ->filters([
                SelectFilter::make('status')
                    ->options([
                        'pending' => 'Pending',
                        'under_review' => 'Under Review',
                        'approved' => 'Approved',
                        'denied' => 'Denied',
                        'refunded' => 'Refunded',
                    ])
                    ->default('pending'),
            ])
            ->defaultSort('created_at', 'desc')
            ->recordActions([
                ViewAction::make(),
                EditAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
