<?php

namespace App\Filament\Resources\Products\Schemas;

use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\Toggle;
use Filament\Schemas\Schema;

class ProductForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('seller_id')
                    ->relationship('seller', 'name'),
                Select::make('category_id')
                    ->relationship('category', 'name'),
                TextInput::make('title')
                    ->required(),
                Textarea::make('short_description')
                    ->columnSpanFull(),
                TextInput::make('balance'),
                TextInput::make('price')
                    ->required()
                    ->numeric()
                    ->prefix('$'),
                Textarea::make('details')
                    ->columnSpanFull(),
                Toggle::make('sold')
                    ->required(),
                TextInput::make('sold_to')
                    ->required()
                    ->default(''),
                Toggle::make('deleted')
                    ->required(),
                Toggle::make('refund')
                    ->required(),
                DateTimePicker::make('joined')
                    ->required(),
                DateTimePicker::make('purchased_time'),
                TextInput::make('updated'),
            ]);
    }
}
