<?php

namespace App\Filament\Resources\Users\Schemas;

use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class UserForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('name')
                    ->required(),
                TextInput::make('email')
                    ->label('Email address')
                    ->email(),
                TextInput::make('password')
                    ->password(),
                TextInput::make('telegram_id')
                    ->tel(),
                TextInput::make('username'),
                TextInput::make('role')
                    ->default('user'),
                TextInput::make('balance_usd')
                    ->numeric()
                    ->default(0),
                TextInput::make('kyc_level')
                    ->numeric()
                    ->default(0),
            ]);
    }
}
