<?php

namespace App\Filament\Widgets;

use App\Models\Product;
use Filament\Widgets\ChartWidget;

class ProductStatsWidget extends ChartWidget
{
    protected static ?int $sort = 3;

    public function getHeading(): ?string
    {
        return 'Product Status Distribution';
    }

    protected function getData(): array
    {
        $available = Product::where('sold', false)
            ->where('deleted', false)
            ->count();

        $sold = Product::where('sold', true)
            ->where('deleted', false)
            ->count();

        $deleted = Product::where('deleted', true)->count();

        return [
            'datasets' => [
                [
                    'label' => 'Products',
                    'data' => [$available, $sold, $deleted],
                    'backgroundColor' => [
                        'rgb(34, 197, 94)',  // Green for available
                        'rgb(59, 130, 246)',  // Blue for sold
                        'rgb(239, 68, 68)',   // Red for deleted
                    ],
                ],
            ],
            'labels' => ['Available', 'Sold', 'Deleted'],
        ];
    }

    protected function getType(): string
    {
        return 'doughnut';
    }
}
