<?php

declare(strict_types=1);

namespace App\Http\Controllers\Webhooks;

use App\Bot\Data\TelegramUpdateData;
use App\Http\Controllers\Controller;
use App\Http\Requests\TelegramWebhookRequest;
use App\Jobs\HandleTelegramUpdate;
use Illuminate\Http\JsonResponse;

class TelegramWebhookController extends Controller
{
    public function handle(TelegramWebhookRequest $request): JsonResponse
    {
        $updateData = TelegramUpdateData::from($request->validated());
        
        HandleTelegramUpdate::dispatch($updateData);
        
        return response()->json(['ok' => true]);
    }
}
