<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class TelegramWebhookRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        $webhookSecret = config('services.telegram.webhook_secret');
        
        if (!$webhookSecret) {
            return true;
        }

        return $this->header('X-Telegram-Bot-Api-Secret-Token') === $webhookSecret;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'update_id' => 'required|integer',
            'message' => 'sometimes|array',
            'message.message_id' => 'required_with:message|integer',
            'message.from' => 'required_with:message|array',
            'message.from.id' => 'required_with:message.from|integer',
            'message.chat' => 'required_with:message|array',
            'message.chat.id' => 'required_with:message.chat|integer',
            'message.text' => 'sometimes|string',
            'callback_query' => 'sometimes|array',
            'callback_query.id' => 'required_with:callback_query|string',
            'callback_query.from' => 'required_with:callback_query|array',
            'callback_query.from.id' => 'required_with:callback_query.from|integer',
            'callback_query.message' => 'required_with:callback_query|array',
            'callback_query.data' => 'required_with:callback_query|string',
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'update_id.required' => 'Invalid Telegram update format',
            'message.from.id.required_with' => 'Message must include sender information',
            'callback_query.data.required_with' => 'Callback query must include data',
        ];
    }
}
