<?php

namespace App\Jobs;

use App\Models\User;
use App\Services\TelegramService;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;

class BroadcastCustomMessage implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new job instance.
     */
    public function __construct(
        public string $message
    ) {}

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $telegram = app(TelegramService::class);

        // Get all users with a Telegram ID
        $users = User::whereNotNull('telegram_id')
            ->get();

        $successCount = 0;
        $failureCount = 0;

        // Send broadcast to all users
        foreach ($users as $user) {
            try {
                $telegram->sendMessage((int)$user->telegram_id, $this->message);
                $successCount++;

                // Small delay to avoid rate limiting
                usleep(50000); // 50ms delay
            } catch (\Exception $e) {
                $failureCount++;
                \Log::error('Custom broadcast failed for user', [
                    'user_id' => $user->id,
                    'telegram_id' => $user->telegram_id,
                    'error' => $e->getMessage()
                ]);
            }
        }

    }
}
