<?php

declare(strict_types=1);

namespace App\Listeners;

use App\Events\DepositConfirmed;
use App\Services\TelegramService;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

class NotifyDepositConfirmed implements ShouldQueue
{
    use InteractsWithQueue;

    public function __construct(
        private TelegramService $telegram
    ) {}

    public function handle(DepositConfirmed $event): void
    {
        // Notification is already sent by BitGoWebhookController
        // This listener can be used for additional side effects like:
        // - Logging to analytics
        // - Updating user statistics
        // - Sending notifications to admin
        
        // For now, it's a placeholder for future enhancements
    }
}
