<?php

declare(strict_types=1);

namespace App\Listeners;

use App\Events\ProductPurchased;
use App\Services\TelegramService;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

class SendPurchaseReceipt implements ShouldQueue
{
    use InteractsWithQueue;

    public function __construct(
        private TelegramService $telegram
    ) {}

    public function handle(ProductPurchased $event): void
    {
        // Purchase receipt is already sent by PurchaseProductAction
        // This listener can be used for additional side effects like:
        // - Logging to analytics
        // - Sending to fulfillment system
        // - Updating inventory
        // - Notifying admin of sale
        
        // For now, it's a placeholder for future enhancements
    }
}
