<?php

declare(strict_types=1);

namespace App\Listeners;

use App\Events\UserRegistered;
use App\Services\TelegramService;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

class SendWelcomeMessage implements ShouldQueue
{
    use InteractsWithQueue;

    public function __construct(
        private TelegramService $telegram
    ) {}

    public function handle(UserRegistered $event): void
    {
        // Welcome message is already sent by ProcessStartCommand
        // This listener can be used for additional side effects like:
        // - Logging to analytics
        // - Sending to CRM
        // - Triggering welcome email (if implemented)
        
        // For now, it's a placeholder for future enhancements
    }
}
