<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Deposit extends Model
{
    protected $fillable = [
        'user_id',
        'deposit_request_id',
        'txid',
        'address',
        'amount_satoshi',
        'confirmations',
        'rate_usd_per_btc',
        'credited_usd',
        'status',
        'detected_at',
        'credited_at',
        'metadata',
    ];

    protected function casts(): array
    {
        return [
            'amount_satoshi' => 'integer',
            'confirmations' => 'integer',
            'rate_usd_per_btc' => 'decimal:8',
            'credited_usd' => 'decimal:2',
            'detected_at' => 'datetime',
            'credited_at' => 'datetime',
            'metadata' => 'array',
        ];
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function depositRequest(): BelongsTo
    {
        return $this->belongsTo(DepositRequest::class);
    }

    /**
     * Get the USD amount for the deposit (accessor for referral service)
     */
    public function getAmountUsdAttribute(): float
    {
        return (float) $this->credited_usd;
    }
}
