<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Product extends Model
{
    protected $fillable = [
        'seller_id',
        'category_id',
        'title',
        'short_description',
        'balance',
        'price',
        'details',
        'sold',
        'sold_to',
        'deleted',
        'refund',
        'joined',
        'purchased_time',
        'updated',
    ];

    protected function casts(): array
    {
        return [
            'price' => 'decimal:2',
            'sold' => 'boolean',
            'deleted' => 'boolean',
            'refund' => 'boolean',
            'joined' => 'datetime',
            'purchased_time' => 'datetime',
        ];
    }

    public function seller(): BelongsTo
    {
        return $this->belongsTo(User::class, 'seller_id');
    }

    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class);
    }
}
