<?php

namespace App\Services;

class TranslationService
{
    private array $translations = [
        'en' => [
            // Main Menu
            'welcome' => "👋 Welcome to {site_name}!",
            'main_menu' => "🏠 Main Menu",
            'browse_products' => "🛍️ Browse Products",
            'my_orders' => "📦 My Orders",
            'my_balance' => "💰 My Balance: ${balance}",
            'deposit' => "💵 Deposit",
            'help' => "❓ Help",
            'settings' => "⚙️ Settings",
            'language' => "🌍 Language",
            'referral' => "👥 Referral Program",
            
            // Language Selection
            'select_language' => "🌍 Select your language:",
            'language_updated' => "✅ Language updated to English",
            
            // Referral System
            'referral_title' => "👥 Referral Program",
            'your_referral_code' => "🎁 Your Referral Code: <code>{code}</code>",
            'referral_link' => "🔗 Your Referral Link:",
            'referral_earnings' => "💰 Referral Earnings: ${earnings}",
            'total_referrals' => "👥 Total Referrals: {count}",
            'referral_commission' => "💵 Commission: 10% of deposits",
            'referral_instructions' => "Share your referral link with friends. You'll earn 10% commission on all their deposits!",
            'copy_link' => "📋 Copy Link",
            'share_link' => "📤 Share Link",
            
            // Products
            'category_products' => "📦 {category}",
            'no_products' => "No products available in this category yet.\n\nCheck back later!",
            'available_products' => "Available products:",
            'price' => "💰 Price: ${price}",
            'buy_product' => "🛒 Buy {title} - ${price}",
            
            // Navigation
            'back' => "🔙 Back",
            'back_to_categories' => "🔙 Back to Categories",
            'previous' => "⬅️ Previous",
            'next' => "Next ➡️",
            
            // Orders
            'no_orders' => "You haven't placed any orders yet.",
            'order_history' => "📦 Order History",
            
            // Balance & Deposits
            'balance_info' => "💰 Your Balance: ${balance}\n\n💵 Minimum Deposit: ${min_deposit}",
            'create_deposit' => "➕ Create Deposit",
            'deposit_instructions' => "Send Bitcoin to the address below:",
            
            // Errors
            'category_not_found' => "❌ Category not found.",
            'product_not_found' => "❌ Product not found.",
            'error_occurred' => "❌ An error occurred. Please try again.",
            
            // Success Messages
            'success' => "✅ Success!",
            'order_placed' => "✅ Order placed successfully!",
            
            // Support
            'contact_support' => "📞 Contact Support: @{support}",
        ],
        
        'ru' => [
            // Main Menu
            'welcome' => "👋 Добро пожаловать в {site_name}!",
            'main_menu' => "🏠 Главное меню",
            'browse_products' => "🛍️ Просмотр товаров",
            'my_orders' => "📦 Мои заказы",
            'my_balance' => "💰 Мой баланс: ${balance}",
            'deposit' => "💵 Пополнить",
            'help' => "❓ Помощь",
            'settings' => "⚙️ Настройки",
            'language' => "🌍 Язык",
            'referral' => "👥 Реферальная программа",
            
            // Language Selection
            'select_language' => "🌍 Выберите язык:",
            'language_updated' => "✅ Язык изменен на Русский",
            
            // Referral System
            'referral_title' => "👥 Реферальная программа",
            'your_referral_code' => "🎁 Ваш реферальный код: <code>{code}</code>",
            'referral_link' => "🔗 Ваша реферальная ссылка:",
            'referral_earnings' => "💰 Заработано: ${earnings}",
            'total_referrals' => "👥 Всего рефералов: {count}",
            'referral_commission' => "💵 Комиссия: 10% от депозитов",
            'referral_instructions' => "Поделитесь реферальной ссылкой с друзьями. Вы получите 10% комиссии со всех их депозитов!",
            'copy_link' => "📋 Копировать ссылку",
            'share_link' => "📤 Поделиться",
            
            // Products
            'category_products' => "📦 {category}",
            'no_products' => "В этой категории пока нет товаров.\n\nЗагляните позже!",
            'available_products' => "Доступные товары:",
            'price' => "💰 Цена: ${price}",
            'buy_product' => "🛒 Купить {title} - ${price}",
            
            // Navigation
            'back' => "🔙 Назад",
            'back_to_categories' => "🔙 К категориям",
            'previous' => "⬅️ Предыдущая",
            'next' => "Следующая ➡️",
            
            // Orders
            'no_orders' => "У вас пока нет заказов.",
            'order_history' => "📦 История заказов",
            
            // Balance & Deposits
            'balance_info' => "💰 Ваш баланс: ${balance}\n\n💵 Минимальный депозит: ${min_deposit}",
            'create_deposit' => "➕ Создать депозит",
            'deposit_instructions' => "Отправьте Bitcoin на адрес ниже:",
            
            // Errors
            'category_not_found' => "❌ Категория не найдена.",
            'product_not_found' => "❌ Товар не найден.",
            'error_occurred' => "❌ Произошла ошибка. Попробуйте снова.",
            
            // Success Messages
            'success' => "✅ Успешно!",
            'order_placed' => "✅ Заказ успешно размещен!",
            
            // Support
            'contact_support' => "📞 Поддержка: @{support}",
        ],
    ];

    public function get(string $key, string $language = 'en', array $replacements = []): string
    {
        $text = $this->translations[$language][$key] ?? $this->translations['en'][$key] ?? $key;
        
        foreach ($replacements as $search => $replace) {
            $text = str_replace('{' . $search . '}', $replace, $text);
        }
        
        return $text;
    }

    public function getAvailableLanguages(): array
    {
        return [
            'en' => '🇬🇧 English',
            'ru' => '🇷🇺 Русский',
        ];
    }
}
