<?php

namespace App\Traits;

use App\Models\User;

trait HasBotTranslations
{
    /**
     * Get user's language preference
     */
    protected function getUserLanguage($telegramId): string
    {
        $user = User::where('telegram_id', (string)$telegramId)->first();
        return $user?->language ?? 'ru';
    }

    /**
     * Translate bot message
     */
    protected function trans(string $key, array $replace = [], $telegramId = null): string
    {
        $locale = $telegramId ? $this->getUserLanguage($telegramId) : app()->getLocale();
        return __("bot.{$key}", $replace, $locale);
    }

    /**
     * Set app locale for user
     */
    protected function setUserLocale($telegramId): void
    {
        $locale = $this->getUserLanguage($telegramId);
        app()->setLocale($locale);
    }
}
