<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('telegram_id')->unique()->nullable()->after('id');
            $table->string('username')->nullable()->after('telegram_id');
            $table->string('first_name')->nullable()->after('username');
            $table->string('last_name')->nullable()->after('first_name');
            $table->string('role')->default('user')->after('email')->index();
            $table->decimal('balance_usd', 14, 2)->default(0.00)->after('role');
            $table->tinyInteger('kyc_level')->default(0)->after('balance_usd')->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['telegram_id', 'username', 'first_name', 'last_name', 'role', 'balance_usd', 'kyc_level']);
        });
    }
};
