<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->foreignId('seller_id')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('category_id')->nullable()->constrained('categories')->onDelete('set null');
            $table->string('title');
            $table->text('short_description')->nullable();
            $table->string('balance')->nullable();
            $table->decimal('price', 12, 2);
            $table->longText('details')->nullable();
            $table->boolean('sold')->default(false)->index();
            $table->string('sold_to')->default('');
            $table->boolean('deleted')->default(false)->index();
            $table->boolean('refund')->default(false);
            $table->timestamp('joined')->useCurrent();
            $table->timestamp('purchased_time')->nullable();
            $table->string('updated')->nullable();
            $table->timestamps();
            
            $table->index(['category_id', 'sold', 'deleted']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
