<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('deposits', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('deposit_request_id')->constrained()->onDelete('cascade');
            $table->string('txid')->unique();
            $table->string('address');
            $table->unsignedBigInteger('amount_satoshi');
            $table->unsignedInteger('confirmations')->default(0);
            $table->decimal('rate_usd_per_btc', 18, 8)->nullable();
            $table->decimal('credited_usd', 14, 2)->nullable();
            $table->string('status')->default('pending')->index();
            $table->timestamp('detected_at')->nullable();
            $table->timestamp('credited_at')->nullable();
            $table->json('metadata')->nullable();
            $table->timestamps();
            
            $table->index(['user_id', 'status']);
            $table->index('deposit_request_id');
            $table->index('address');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('deposits');
    }
};
