<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            [
                'name' => 'Templates',
                'slug' => 'templates',
                'description' => 'Premium templates and themes',
                'parent_id' => null,
                'is_active' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'API Credits',
                'slug' => 'api-credits',
                'description' => 'API access and credits',
                'parent_id' => null,
                'is_active' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'Digital Products',
                'slug' => 'digital-products',
                'description' => 'Various digital products',
                'parent_id' => null,
                'is_active' => true,
                'sort_order' => 3,
            ],
        ];

        foreach ($categories as $category) {
            \App\Models\Category::create($category);
        }

        // Create subcategories
        $templatesCategory = \App\Models\Category::where('slug', 'templates')->first();
        
        \App\Models\Category::create([
            'name' => 'Web Templates',
            'slug' => 'web-templates',
            'description' => 'Website templates',
            'parent_id' => $templatesCategory->id,
            'is_active' => true,
            'sort_order' => 1,
        ]);

        \App\Models\Category::create([
            'name' => 'Mobile Templates',
            'slug' => 'mobile-templates',
            'description' => 'Mobile app templates',
            'parent_id' => $templatesCategory->id,
            'is_active' => true,
            'sort_order' => 2,
        ]);
    }
}
