<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Product;
use App\Models\Category;

class ProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = Category::all();
        
        if ($categories->isEmpty()) {
            $this->command->warn('No categories found. Please run CategorySeeder first.');
            return;
        }

        $products = [
            // Templates Category
            [
                'category_id' => Category::where('slug', 'templates')->first()?->id,
                'title' => 'Premium Laravel Admin Template',
                'short_description' => 'Modern and responsive Laravel admin dashboard template with 100+ components',
                'details' => "Features:\n- 100+ UI Components\n- Dark/Light Mode\n- Responsive Design\n- Laravel 11 Compatible\n- Full Documentation",
                'price' => 49.99,
                'sold' => false,
                'deleted' => false,
            ],
            [
                'category_id' => Category::where('slug', 'templates')->first()?->id,
                'title' => 'React E-commerce Template',
                'short_description' => 'Complete e-commerce solution built with React and Tailwind CSS',
                'details' => "Includes:\n- Shopping Cart\n- Payment Integration\n- Product Management\n- User Authentication\n- Mobile Responsive",
                'price' => 79.99,
                'sold' => false,
                'deleted' => false,
            ],
            [
                'category_id' => Category::where('slug', 'templates')->first()?->id,
                'title' => 'Vue.js SaaS Dashboard',
                'short_description' => 'Professional SaaS dashboard template with Vue 3 and TypeScript',
                'details' => "Features:\n- Vue 3 Composition API\n- TypeScript Support\n- Chart Integration\n- Multi-tenant Ready\n- API Documentation",
                'price' => 59.99,
                'sold' => false,
                'deleted' => false,
            ],

            // API Credits Category
            [
                'category_id' => Category::where('slug', 'api-credits')->first()?->id,
                'title' => 'OpenAI API Credits - 1000 Requests',
                'short_description' => 'Get 1000 API requests for GPT-4 and other OpenAI models',
                'details' => "Package includes:\n- 1000 API Requests\n- GPT-4 Access\n- DALL-E Access\n- Whisper API\n- Valid for 30 days",
                'price' => 25.00,
                'sold' => false,
                'deleted' => false,
            ],
            [
                'category_id' => Category::where('slug', 'api-credits')->first()?->id,
                'title' => 'SMS API Credits - 5000 Messages',
                'short_description' => 'Send 5000 SMS messages worldwide with our reliable API',
                'details' => "Features:\n- 5000 SMS Credits\n- Global Coverage\n- Delivery Reports\n- 2-Way Messaging\n- No Expiry",
                'price' => 15.00,
                'sold' => false,
                'deleted' => false,
            ],
            [
                'category_id' => Category::where('slug', 'api-credits')->first()?->id,
                'title' => 'Email API Credits - 10000 Emails',
                'short_description' => 'Professional email sending service with 10000 email credits',
                'details' => "Includes:\n- 10000 Email Credits\n- SMTP Access\n- Tracking & Analytics\n- Template Support\n- 99.9% Uptime",
                'price' => 20.00,
                'sold' => false,
                'deleted' => false,
            ],

            // Digital Products Category
            [
                'category_id' => Category::where('slug', 'digital-products')->first()?->id,
                'title' => 'Complete Web Development Course',
                'short_description' => 'Learn full-stack web development from scratch to advanced',
                'details' => "Course Content:\n- HTML, CSS, JavaScript\n- React & Vue.js\n- Node.js & Express\n- Database Design\n- 50+ Hours of Video\n- Lifetime Access",
                'price' => 99.99,
                'sold' => false,
                'deleted' => false,
            ],
            [
                'category_id' => Category::where('slug', 'digital-products')->first()?->id,
                'title' => 'Premium Icon Pack - 5000 Icons',
                'short_description' => 'Professional icon set with 5000+ icons in multiple formats',
                'details' => "Package includes:\n- 5000+ Icons\n- SVG, PNG, ICO formats\n- Multiple Styles\n- Commercial License\n- Regular Updates",
                'price' => 29.99,
                'sold' => false,
                'deleted' => false,
            ],
            [
                'category_id' => Category::where('slug', 'digital-products')->first()?->id,
                'title' => 'Stock Photos Bundle - 1000 Images',
                'short_description' => 'High-quality stock photos for commercial use',
                'details' => "Collection includes:\n- 1000 HD Images\n- Commercial License\n- Multiple Categories\n- High Resolution\n- Instant Download",
                'price' => 39.99,
                'sold' => false,
                'deleted' => false,
            ],
            [
                'category_id' => Category::where('slug', 'digital-products')->first()?->id,
                'title' => 'WordPress Plugin - Advanced SEO',
                'short_description' => 'Powerful SEO plugin for WordPress with AI optimization',
                'details' => "Features:\n- AI Content Analysis\n- Schema Markup\n- XML Sitemaps\n- Social Integration\n- 1 Year Updates",
                'price' => 44.99,
                'sold' => false,
                'deleted' => false,
            ],
        ];

        foreach ($products as $product) {
            if ($product['category_id']) {
                Product::create($product);
            }
        }

        $this->command->info('Products seeded successfully!');
    }
}
