<?php

return [
    // Main Menu
    'welcome' => '👋 Welcome to :site_name!',
    'welcome_back' => '👋 Welcome back, :name!',
    'main_menu' => '🏠 Main Menu',
    'browse_products' => '🛍️ Browse Products',
    'my_orders' => '📦 My Orders',
    'my_purchases' => '📦 My Purchases',
    'my_balance' => '💰 My Balance',
    'deposit' => '💵 Deposit',
    'deposit_btc' => '💰 Deposit BTC',
    'help' => '❓ Help',
    'settings' => '⚙️ Settings',
    'language' => '🌍 Language',
    'referral' => '👥 Referral Program',
    'my_reports' => '📋 My Reports',
    'rules_terms' => '📜 Rules & Terms',
    
    // Language Selection
    'select_language' => '🌍 Select your language:',
    'language_updated' => '✅ Language updated to English',
    'language_english' => '🇬🇧 English',
    'language_russian' => '🇷🇺 Русский',
    
    // Referral System
    'referral_title' => '👥 Referral Program',
    'your_referral_code' => '🎁 Your Referral Code: <code>:code</code>',
    'referral_link' => '🔗 Your Referral Link:',
    'referral_earnings' => '💰 Referral Earnings: $:earnings',
    'total_referrals' => '👥 Total Referrals: :count',
    'active_referrals' => '✅ Active Referrals: :count',
    'referral_commission' => '💵 Commission: 10% of deposits',
    'referral_instructions' => 'Share your referral link with friends. You\'ll earn 10% commission on all their deposits!',
    'copy_link' => '📋 Copy Link',
    'share_link' => '📤 Share Link',
    
    // Products & Categories
    'category_products' => '📦 :category',
    'no_products' => "No products available in this category yet.\n\nCheck back later!",
    'available_products' => 'Available products:',
    'products_available' => ':count products available',
    'price' => '💰 Price: $:price',
    'buy_product' => '🛒 Buy :title - $:price',
    'select_subcategory' => 'Select a subcategory:',
    
    // Navigation
    'back' => '🔙 Back',
    'back_to_categories' => '🔙 Back to Categories',
    'back_to_menu' => '🔙 Back to Menu',
    'previous' => '⬅️ Previous',
    'next' => 'Next ➡️',
    'home' => '🏠 Main Menu',
    
    // Balance & Deposits
    'balance_title' => '💰 Your Balance',
    'current_balance' => 'Current Balance: $:balance',
    'balance_info' => "💰 Your Balance: $:balance\n\n💵 Minimum Deposit: $:min_deposit",
    'create_deposit' => '➕ Create Deposit',
    'deposit_instructions' => 'Send Bitcoin to the address below:',
    'deposit_address' => '📍 Deposit Address:',
    'deposit_amount' => '💰 Amount: :amount BTC',
    'deposit_status' => '📊 Status: :status',
    'deposit_confirmed' => "✅ Deposit Confirmed!\n\nAmount: :btc BTC\nCredited: $:usd USD\nRate: $:rate/BTC\n\nNew balance: $:balance",
    'minimum_deposit' => 'Minimum deposit: $:amount',
    
    // Orders & Purchases
    'no_orders' => "You haven't placed any orders yet.",
    'order_history' => '📦 Order History',
    'order_details' => '📦 Order #:id',
    'order_status' => 'Status: :status',
    'order_total' => 'Total: $:amount',
    'order_date' => 'Date: :date',
    'view_order' => '👁️ View Order #:id',
    
    // Reports
    'report_issue' => '⚠️ Report Issue',
    'no_reports' => "You haven't submitted any reports yet.",
    'report_status' => 'Status: :status',
    'report_submitted' => '✅ Report submitted successfully!',
    'view_report' => '📋 View Report',
    'back_to_reports' => '🔙 Back to Reports',
    'skip_screenshot' => '⏭️ Skip Screenshot',
    'try_again' => '🔄 Try Again',
    'screenshot_optional' => '📷 <b>Screenshot Evidence (Optional)</b>',
    'invalid_screenshot_url' => '❌ Invalid URL. Please provide a valid prnt.sc or imgur link.',
    'screenshot_prompt' => 'Or click Skip to continue without screenshot.',
    'cannot_report' => '❌ <b>Cannot Report</b>',
    'report_time_limit' => 'You can only report issues within :days days of purchase.',
    'report_already_exists' => '⚠️ <b>Report Already Exists</b>',
    'pending_report_exists' => 'You already have a pending report for this order.',
    'ticket_number' => 'Ticket #:id',
    'check_my_reports' => 'Check status in 📋 My Reports',
    'report_issue_title' => '🚨 <b>Report Issue</b>',
    'order_number' => 'Order #:id',
    'total' => 'Total: $:amount',
    'describe_issue' => 'Please describe the issue with your order:',
    'report_reason_prompt' => '💬 <b>Describe the Issue</b>\n\nPlease explain what went wrong with your order. Be as detailed as possible.',
    
    // Errors & Warnings
    'category_not_found' => '❌ Category not found.',
    'product_not_found' => '❌ Product not found.',
    'error_occurred' => '❌ An error occurred. Please try again.',
    'product_sold' => '❌ This product has already been sold.',
    'terms_required' => "⚠️ Terms & Conditions Required\n\nYou must accept our Terms & Conditions before using this service.\n\nPlease use /start to review and accept the terms.",
    'deposit_failed' => '❌ Failed to create deposit address. Please try again.',
    'invalid_url' => '❌ Please provide a valid URL.',
    'order_too_old' => 'This order is too old to report.',
    'already_reported' => 'You have already reported this order.',
    
    // Success Messages
    'success' => '✅ Success!',
    'order_placed' => '✅ Order placed successfully!',
    'terms_accepted' => "✅ Terms Accepted!\n\nWelcome to :site_name! You can now browse products and make purchases.",
    
    // Terms & Conditions
    'welcome_terms' => "👋 Welcome to :site_name!\n\nBefore you can use our service, please read and accept our Terms & Conditions:",
    'accept_terms' => '✅ Accept',
    'decline_terms' => '❌ Decline',
    'terms_accepted_title' => '✅ <b>Terms Accepted!</b>',
    'terms_accepted_thank_you' => 'Thank you for accepting our Terms & Conditions.',
    'terms_accepted_can_use' => 'You can now use all features of our store.',
    'terms_accepted_start' => 'Use /start to begin shopping!',
    'terms_declined_title' => '❌ <b>Terms Declined</b>',
    'terms_declined_must_accept' => 'You must accept our Terms & Conditions to use this service.',
    'terms_declined_try_again' => 'If you change your mind, use /start to try again.',
    'terms_declined' => "❌ You must accept the Terms & Conditions to use this service.\n\nUse /start to try again.",
    
    // Help & Support
    'help_title' => '❓ Help & Support',
    'contact_support' => '📞 Contact Support: @:support',
    'help_message' => "Need help? Here's what you can do:\n\n🛍️ Browse products\n💰 Make deposits\n📦 View your orders\n📋 Report issues\n\nFor additional support, contact @:support",
    
    // Maintenance
    'maintenance_mode' => "🔧 Maintenance Mode\n\nThe bot is currently under maintenance. Please try again later.",
    
    // Statuses
    'status_pending' => '⏳ Pending',
    'status_processing' => '🔄 Processing',
    'status_completed' => '✅ Completed',
    'status_confirmed' => '✅ Confirmed',
    'status_cancelled' => '❌ Cancelled',
    'status_refunded' => '💰 Refunded',
    
    // New User Welcome
    'new_user_welcome' => "🎉 Welcome to :site_name!\n\nYou're all set! Here's what you can do:\n\n🛍️ Browse our products\n💰 Deposit funds\n👥 Invite friends and earn 10% commission\n🌍 Change language\n\nLet's get started!",
    'returning_user_welcome' => "👋 Welcome back!\n\n📦 We have :count products available.\n💰 Your balance: $:balance\n\nWhat would you like to do?",
    
    // Bot Messages (moved from settings)
    'welcome_message' => "Welcome to our tools store! 🎉\n\n🎯 What we offer:\n• Bank logs, Fullz, Email access and more..\n• Secure Bitcoin payments\n• 24/7 automated service\n• Report system for issues\n\n💡 How it works:\n1️⃣ Deposit Bitcoin → Get USD balance\n2️⃣ Browse our catalog\n3️⃣ Purchase & receive instantly\n\nReady to start shopping?",
    
    'rules_text' => "📜 <b>Store Rules & Terms</b>\n\n<b>Purchase Policy:</b>\n• All sales are final after delivery\n• Products delivered instantly\n• Check product details before buying\n\n<b>Refund Policy:</b>\n• Report issues within 24 hours of purchase\n• Valid issues will be refunded\n• Provide proof (screenshots) when possible\n\n<b>Acceptable Use:</b>\n• Use products legally and ethically\n• No chargebacks or payment disputes\n• Respect our support team\n\n<b>Account Rules:</b>\n• One account per person\n• Keep your account secure\n• No sharing of purchased products\n\nBy using our service, you agree to these terms.",
    
    'accept_terms_question' => 'Do you accept these terms?',
    
    'help_text' => "❓ <b>Help & Support</b>\n\n<b>Available Commands:</b>\n/start - Main menu\n/balance - Check your balance\n/deposit - Create deposit address\n/help - Show this help\n/history - Transaction history\n/rules - Store rules & terms\n/myreports - View your reports\n\n<b>Need Assistance?</b>\nContact: @:support\n\n<b>How to Shop:</b>\n1. Deposit Bitcoin to get USD balance\n2. Browse products by category\n3. Purchase and receive instantly\n4. Report issues if product doesn't work\n\nWe're here to help! 💬",
    
    'report_instructions' => "📷 <b>Screenshot Instructions:</b>\n\n1. Take a screenshot of the issue\n2. Upload it to: https://prnt.sc/\n3. Copy the link you receive\n4. Paste it here\n\nExample: https://prnt.sc/abc123\n\n💡 Screenshots help us verify and process your report faster!",
    
    'deposit_instructions_text' => "💰 <b>Deposit Instructions:</b>\n\nSend BTC to this address:\n:address\n\n<b>Important:</b>\n• Minimum deposit: $:min_deposit USD\n• You'll be credited after 2 confirmations\n• Credited at current market rate\n• ⚠️ Only send Bitcoin (BTC) to this address!\n\n<b>Need help?</b>\nContact @:support if you have questions.",
    
    // Deposit Status
    'waiting_for_confirmation' => '⏳ <b>Waiting for Confirmation</b>',
    'deposit_address_label' => '<b>Address:</b> :address',
    'status_label' => 'Status: :status',
    'waiting_for_transaction' => 'We\'re waiting for your Bitcoin transaction to be confirmed.',
    
    // Browse & Categories
    'browse_categories' => '🛍 <b>Browse Categories</b>',
    'select_category' => 'Select a category:',
    
    // Product Details
    'product_not_available' => '❌ Product not available.',
    'product_price' => '💰 <b>Price:</b> $:price',
    'product_description' => '📝 <b>Description:</b>',
    'product_details' => 'ℹ️ <b>Details:</b>',
    'buy_now' => '🛒 Buy Now',
    'back_to_category' => '🔙 Back to Category',
    
    // Purchase Flow
    'insufficient_balance' => '❌ <b>Insufficient Balance</b>',
    'need_more' => 'You need $:amount more.',
    'current_balance_label' => 'Current balance: $:balance',
    'product_price_label' => 'Product price: $:price',
    'purchase_successful' => '✅ <b>Purchase Successful!</b>',
    'product_label' => 'Product: :title',
    'amount_label' => 'Amount: $:amount',
    'product_details_label' => '📄 <b>Product Details:</b>',
    'new_balance' => 'New balance: $:balance',
    
    // Balance Display
    'your_balance' => '💵 <b>Your Balance</b>',
    'current_balance_display' => 'Current Balance: <b>$:balance</b>',
    'statistics' => '📊 <b>Statistics:</b>',
    'total_deposited' => 'Total Deposited: $:amount',
    'total_spent' => 'Total Spent: $:amount',
    'pending_deposits' => '⏳ Pending Deposits: :count',
    'history_button' => '📜 History',
    
    // Transaction History
    'transaction_history' => '📜 <b>Transaction History</b>',
    'recent_deposits' => '💰 <b>Recent Deposits:</b>',
    'recent_purchases' => '🛍 <b>Recent Purchases:</b>',
    'no_transactions' => 'No transactions yet.',
    'start_with_deposit' => 'Start by making a deposit!',
    'balance_button' => '💵 Balance',
    'check_status' => 'Check Status',
    
    // Deposit Command
    'deposit_bitcoin_title' => '💰 <b>Deposit Bitcoin</b>',
    'deposit_click_button' => 'Click the button below to create a new deposit address.',
    'deposit_receive_qr' => 'You\'ll receive a unique BTC address with QR code for easy scanning.',
    'create_deposit_address' => '💰 Create Deposit Address',
    
    // My Reports
    'my_reports_title' => '📋 <b>My Reports</b>',
    'no_reports_yet' => 'You haven\'t submitted any reports yet.',
    'report_from_orders' => 'If you have issues with a product, you can report it from your order details.',
    'click_report_details' => 'Click on a report to view details:',
    
    // My Purchases
    'my_purchases_title' => '📦 <b>My Purchases</b>',
    'no_purchases_yet' => 'You haven\'t made any purchases yet.',
    'browse_to_start' => 'Browse our products to get started!',
    'click_order_details' => 'Click on an order to view product details:',
    'items_count' => ':count items',
    'item_count' => '1 item',
    'back_to_purchases' => '🔙 Back to Purchases',
    
    // Order Details
    'order_not_found' => '❌ Order not found.',
    'order_title' => '📋 <b>Order #:id</b>',
    'order_date' => '📅 Date: :date',
    'order_total' => '💰 Total: $:total',
    'order_status' => '✅ Status: :status',
    'product_price_order' => '💵 Price: $:price',
    'product_quantity' => '📦 Quantity: :qty',
    'product_details_order' => '📄 <b>Product Details:</b>',
    
    // Broadcast Messages
    'new_products_added' => '🎉 <b>New Products Added!</b>',
    'added_items_category' => '✨ Added :count :items in category <b>:category</b>',
    'item_singular' => 'item',
    'items_plural' => 'items',
    'browse_updated_catalog' => '💡 Use /start to browse our updated catalog!',
];




