<?php

return [
    // Main Menu
    'welcome' => '👋 Добро пожаловать в :site_name!',
    'welcome_back' => '👋 С возвращением, :name!',
    'main_menu' => '🏠 Главное меню',
    'browse_products' => '🛍️ Просмотр товаров',
    'my_orders' => '📦 Мои заказы',
    'my_purchases' => '📦 Мои покупки',
    'my_balance' => '💰 Мой баланс',
    'deposit' => '💵 Пополнить',
    'deposit_btc' => '💰 Пополнить BTC',
    'help' => '❓ Помощь',
    'settings' => '⚙️ Настройки',
    'language' => '🌍 Язык',
    'referral' => '👥 Реферальная программа',
    'my_reports' => '📋 Мои отчеты',
    'rules_terms' => '📜 Правила и условия',
    
    // Language Selection
    'select_language' => '🌍 Выберите язык:',
    'language_updated' => '✅ Язык изменен на Русский',
    'language_english' => '🇬🇧 English',
    'language_russian' => '🇷🇺 Русский',
    
    // Referral System
    'referral_title' => '👥 Реферальная программа',
    'your_referral_code' => '🎁 Ваш реферальный код: <code>:code</code>',
    'referral_link' => '🔗 Ваша реферальная ссылка:',
    'referral_earnings' => '💰 Заработано: $:earnings',
    'total_referrals' => '👥 Всего рефералов: :count',
    'active_referrals' => '✅ Активных рефералов: :count',
    'referral_commission' => '💵 Комиссия: 10% от депозитов',
    'referral_instructions' => 'Поделитесь реферальной ссылкой с друзьями. Вы получите 10% комиссии со всех их депозитов!',
    'copy_link' => '📋 Копировать ссылку',
    'share_link' => '📤 Поделиться',
    
    // Products & Categories
    'category_products' => '📦 :category',
    'no_products' => "В этой категории пока нет товаров.\n\nЗагляните позже!",
    'available_products' => 'Доступные товары:',
    'products_available' => 'Доступно товаров: :count',
    'price' => '💰 Цена: $:price',
    'buy_product' => '🛒 Купить :title - $:price',
    'select_subcategory' => 'Выберите подкатегорию:',
    
    // Navigation
    'back' => '🔙 Назад',
    'back_to_categories' => '🔙 К категориям',
    'back_to_menu' => '🔙 В меню',
    'previous' => '⬅️ Предыдущая',
    'next' => 'Следующая ➡️',
    'home' => '🏠 Главное меню',
    
    // Balance & Deposits
    'balance_title' => '💰 Ваш баланс',
    'current_balance' => 'Текущий баланс: $:balance',
    'balance_info' => "💰 Ваш баланс: $:balance\n\n💵 Минимальный депозит: $:min_deposit",
    'create_deposit' => '➕ Создать депозит',
    'deposit_instructions' => 'Отправьте Bitcoin на адрес ниже:',
    'deposit_address' => '📍 Адрес депозита:',
    'deposit_amount' => '💰 Сумма: :amount BTC',
    'deposit_status' => '📊 Статус: :status',
    'deposit_confirmed' => "✅ Депозит подтвержден!\n\nСумма: :btc BTC\nЗачислено: $:usd USD\nКурс: $:rate/BTC\n\nНовый баланс: $:balance",
    'minimum_deposit' => 'Минимальный депозит: $:amount',
    
    // Orders & Purchases
    'no_orders' => 'У вас пока нет заказов.',
    'order_history' => '📦 История заказов',
    'order_details' => '📦 Заказ #:id',
    'order_status' => 'Статус: :status',
    'order_total' => 'Итого: $:amount',
    'order_date' => 'Дата: :date',
    'view_order' => '👁️ Просмотр заказа #:id',
    
    // Reports
    'report_issue' => '⚠️ Сообщить о проблеме',
    'no_reports' => 'Вы еще не отправляли отчеты.',
    'report_status' => 'Статус: :status',
    'report_submitted' => '✅ Отчет успешно отправлен!',
    'view_report' => '📋 Просмотр отчета',
    'back_to_reports' => '🔙 К отчетам',
    'skip_screenshot' => '⏭️ Пропустить скриншот',
    'try_again' => '🔄 Попробовать снова',
    'screenshot_optional' => '📷 <b>Доказательства скриншота (опционально)</b>',
    'invalid_screenshot_url' => '❌ Неверный URL. Предоставьте действительную ссылку prnt.sc или imgur.',
    'screenshot_prompt' => 'Или нажмите Пропустить, чтобы продолжить без скриншота.',
    'cannot_report' => '❌ <b>Невозможно сообщить</b>',
    'report_time_limit' => 'Вы можете сообщить о проблемах только в течение :days дней после покупки.',
    'report_already_exists' => '⚠️ <b>Отчет уже существует</b>',
    'pending_report_exists' => 'У вас уже есть ожидающий отчет для этого заказа.',
    'ticket_number' => 'Тикет #:id',
    'check_my_reports' => 'Проверьте статус в 📋 Мои отчеты',
    'report_issue_title' => '🚨 <b>Сообщить о проблеме</b>',
    'order_number' => 'Заказ #:id',
    'total' => 'Итого: $:amount',
    'describe_issue' => 'Пожалуйста, опишите проблему с вашим заказом:',
    'report_reason_prompt' => '💬 <b>Опишите проблему</b>\n\nПожалуйста, объясните, что пошло не так с вашим заказом. Будьте максимально подробны.',
    
    // Errors & Warnings
    'category_not_found' => '❌ Категория не найдена.',
    'product_not_found' => '❌ Товар не найден.',
    'error_occurred' => '❌ Произошла ошибка. Попробуйте снова.',
    'product_sold' => '❌ Этот товар уже продан.',
    'terms_required' => "⚠️ Требуется принятие условий\n\nВы должны принять наши Правила и Условия перед использованием сервиса.\n\nИспользуйте /start для просмотра и принятия условий.",
    'deposit_failed' => '❌ Не удалось создать адрес депозита. Попробуйте снова.',
    'invalid_url' => '❌ Пожалуйста, укажите действительный URL.',
    'order_too_old' => 'Этот заказ слишком старый для отчета.',
    'already_reported' => 'Вы уже сообщили об этом заказе.',
    
    // Success Messages
    'success' => '✅ Успешно!',
    'order_placed' => '✅ Заказ успешно размещен!',
    'terms_accepted' => "✅ Условия приняты!\n\nДобро пожаловать в :site_name! Теперь вы можете просматривать товары и совершать покупки.",
    
    // Terms & Conditions
    'welcome_terms' => "👋 Добро пожаловать в :site_name!\n\nПрежде чем вы сможете использовать наш сервис, пожалуйста, прочитайте и примите наши Правила и Условия:",
    'accept_terms' => '✅ Принять',
    'decline_terms' => '❌ Отклонить',
    'terms_accepted_title' => '✅ <b>Условия приняты!</b>',
    'terms_accepted_thank_you' => 'Спасибо за принятие наших Правил и Условий.',
    'terms_accepted_can_use' => 'Теперь вы можете использовать все функции нашего магазина.',
    'terms_accepted_start' => 'Используйте /start чтобы начать покупки!',
    'terms_declined_title' => '❌ <b>Условия отклонены</b>',
    'terms_declined_must_accept' => 'Вы должны принять наши Правила и Условия для использования сервиса.',
    'terms_declined_try_again' => 'Если передумаете, используйте /start чтобы попробовать снова.',
    'terms_declined' => "❌ Вы должны принять Правила и Условия для использования сервиса.\n\nИспользуйте /start чтобы попробовать снова.",
    
    // Help & Support
    'help_title' => '❓ Помощь и поддержка',
    'contact_support' => '📞 Поддержка: @:support',
    'help_message' => "Нужна помощь? Вот что вы можете сделать:\n\n🛍️ Просмотр товаров\n💰 Пополнение баланса\n📦 Просмотр заказов\n📋 Сообщить о проблеме\n\nДля дополнительной поддержки обращайтесь @:support",
    
    // Maintenance
    'maintenance_mode' => "🔧 Режим обслуживания\n\nБот находится на техническом обслуживании. Пожалуйста, попробуйте позже.",
    
    // Statuses
    'status_pending' => '⏳ Ожидание',
    'status_processing' => '🔄 Обработка',
    'status_completed' => '✅ Завершено',
    'status_confirmed' => '✅ Подтверждено',
    'status_cancelled' => '❌ Отменено',
    'status_refunded' => '💰 Возвращено',
    
    // New User Welcome
    'new_user_welcome' => "🎉 Добро пожаловать в :site_name!\n\nВсе готово! Вот что вы можете сделать:\n\n🛍️ Просмотр товаров\n💰 Пополнение баланса\n👥 Приглашайте друзей и зарабатывайте 10% комиссии\n🌍 Изменить язык\n\nДавайте начнем!",
    'returning_user_welcome' => "👋 С возвращением!\n\n📦 У нас доступно товаров: :count.\n💰 Ваш баланс: $:balance\n\nЧто бы вы хотели сделать?",
    
    // Bot Messages (moved from settings)
    'welcome_message' => "Добро пожаловать в наш магазин инструментов! 🎉\n\n🎯 Банковские журналы, Fullz, доступ к электронной почте и многое другое.\n• Безопасные Bitcoin платежи\n• Автоматический сервис 24/7\n• Система отчетов о проблемах\n\n💡 Как это работает:\n1️⃣ Пополните Bitcoin → Получите USD баланс\n2️⃣ Просмотрите каталог\n3️⃣ Купите и получите мгновенно\n\nГотовы начать покупки?",
    
    'rules_text' => "📜 <b>Правила и Условия Магазина</b>\n\n<b>Политика Покупок:</b>\n• Все продажи окончательны после доставки\n• Товары доставляются мгновенно\n• Проверьте детали товара перед покупкой\n\n<b>Политика Возврата:</b>\n• Сообщайте о проблемах в течение 24 часов после покупки\n• Действительные проблемы будут возвращены\n• Предоставьте доказательства (скриншоты) когда возможно\n\n<b>Приемлемое Использование:</b>\n• Используйте товары законно и этично\n• Никаких возвратов платежей или споров\n• Уважайте нашу службу поддержки\n\n<b>Правила Аккаунта:</b>\n• Один аккаунт на человека\n• Держите свой аккаунт в безопасности\n• Не делитесь купленными товарами\n\nИспользуя наш сервис, вы соглашаетесь с этими условиями.",
    
    'accept_terms_question' => 'Вы принимаете эти условия?',
    
    'help_text' => "❓ <b>Помощь и Поддержка</b>\n\n<b>Доступные Команды:</b>\n/start - Главное меню\n/balance - Проверить баланс\n/deposit - Создать адрес депозита\n/help - Показать эту помощь\n/history - История транзакций\n/rules - Правила и условия\n/myreports - Просмотр отчетов\n\n<b>Нужна Помощь?</b>\nКонтакт: @:support\n\n<b>Как Покупать:</b>\n1. Пополните Bitcoin для получения USD баланса\n2. Просмотрите товары по категориям\n3. Купите и получите мгновенно\n4. Сообщите о проблемах если товар не работает\n\nМы здесь чтобы помочь! 💬",
    
    'report_instructions' => "📷 <b>Инструкции по Скриншотам:</b>\n\n1. Сделайте скриншот проблемы\n2. Загрузите на: https://prnt.sc/\n3. Скопируйте полученную ссылку\n4. Вставьте её здесь\n\nПример: https://prnt.sc/abc123\n\n💡 Скриншоты помогают нам проверить и обработать ваш отчет быстрее!",
    
    'deposit_instructions_text' => "💰 <b>Инструкции по Депозиту:</b>\n\nОтправьте BTC на этот адрес:\n:address\n\n<b>Важно:</b>\n• Минимальный депозит: $:min_deposit USD\n• Зачисление после 2 подтверждений\n• Зачисление по текущему курсу\n• ⚠️ Отправляйте только Bitcoin (BTC) на этот адрес!\n\n<b>Нужна помощь?</b>\nСвяжитесь с @:support если есть вопросы.",
    
    // Deposit Status
    'waiting_for_confirmation' => '⏳ <b>Ожидание подтверждения</b>',
    'deposit_address_label' => '<b>Адрес:</b> :address',
    'status_label' => 'Статус: :status',
    'waiting_for_transaction' => 'Мы ожидаем подтверждения вашей транзакции Bitcoin.',
    
    // Browse & Categories
    'browse_categories' => '🛍 <b>Просмотр категорий</b>',
    'select_category' => 'Выберите категорию:',
    
    // Product Details
    'product_not_available' => '❌ Товар недоступен.',
    'product_price' => '💰 <b>Цена:</b> $:price',
    'product_description' => '📝 <b>Описание:</b>',
    'product_details' => 'ℹ️ <b>Детали:</b>',
    'buy_now' => '🛒 Купить сейчас',
    'back_to_category' => '🔙 К категории',
    
    // Purchase Flow
    'insufficient_balance' => '❌ <b>Недостаточно средств</b>',
    'need_more' => 'Вам нужно еще $:amount.',
    'current_balance_label' => 'Текущий баланс: $:balance',
    'product_price_label' => 'Цена товара: $:price',
    'purchase_successful' => '✅ <b>Покупка успешна!</b>',
    'product_label' => 'Товар: :title',
    'amount_label' => 'Сумма: $:amount',
    'product_details_label' => '📄 <b>Детали товара:</b>',
    'new_balance' => 'Новый баланс: $:balance',
    
    // Balance Display
    'your_balance' => '💵 <b>Ваш баланс</b>',
    'current_balance_display' => 'Текущий баланс: <b>$:balance</b>',
    'statistics' => '📊 <b>Статистика:</b>',
    'total_deposited' => 'Всего пополнено: $:amount',
    'total_spent' => 'Всего потрачено: $:amount',
    'pending_deposits' => '⏳ Ожидающих депозитов: :count',
    'history_button' => '📜 История',
    
    // Transaction History
    'transaction_history' => '📜 <b>История транзакций</b>',
    'recent_deposits' => '💰 <b>Последние депозиты:</b>',
    'recent_purchases' => '🛍 <b>Последние покупки:</b>',
    'no_transactions' => 'Транзакций пока нет.',
    'start_with_deposit' => 'Начните с пополнения баланса!',
    'balance_button' => '💵 Баланс',
    'check_status' => 'Проверить статус',
    
    // Deposit Command
    'deposit_bitcoin_title' => '💰 <b>Пополнение Bitcoin</b>',
    'deposit_click_button' => 'Нажмите кнопку ниже, чтобы создать новый адрес депозита.',
    'deposit_receive_qr' => 'Вы получите уникальный BTC адрес с QR-кодом для удобного сканирования.',
    'create_deposit_address' => '💰 Создать адрес депозита',
    
    // My Reports
    'my_reports_title' => '📋 <b>Мои отчеты</b>',
    'no_reports_yet' => 'Вы еще не отправляли отчеты.',
    'report_from_orders' => 'Если у вас есть проблемы с товаром, вы можете сообщить об этом в деталях заказа.',
    'click_report_details' => 'Нажмите на отчет, чтобы просмотреть детали:',
    
    // My Purchases
    'my_purchases_title' => '📦 <b>Мои покупки</b>',
    'no_purchases_yet' => 'Вы еще не совершали покупок.',
    'browse_to_start' => 'Просмотрите наши товары, чтобы начать!',
    'click_order_details' => 'Нажмите на заказ, чтобы просмотреть детали товара:',
    'items_count' => ':count товаров',
    'item_count' => '1 товар',
    'back_to_purchases' => '🔙 К покупкам',
    
    // Order Details
    'order_not_found' => '❌ Заказ не найден.',
    'order_title' => '📋 <b>Заказ #:id</b>',
    'order_date' => '📅 Дата: :date',
    'order_total' => '💰 Итого: $:total',
    'order_status' => '✅ Статус: :status',
    'product_price_order' => '💵 Цена: $:price',
    'product_quantity' => '📦 Количество: :qty',
    'product_details_order' => '📄 <b>Детали товара:</b>',
    
    // Broadcast Messages
    'new_products_added' => '🎉 <b>Добавлены новые товары!</b>',
    'added_items_category' => '✨ Добавлено :count :items в категории <b>:category</b>',
    'item_singular' => 'товар',
    'items_plural' => 'товаров',
    'browse_updated_catalog' => '💡 Используйте /start чтобы просмотреть обновленный каталог!',
];




