<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Webhooks\TelegramWebhookController;
use App\Http\Controllers\BitGoWebhookController;

Route::get('/', function () {
    return view('welcome');
});

Route::post('/api/webhooks/telegram', [TelegramWebhookController::class, 'handle'])
    ->withoutMiddleware([\Illuminate\Foundation\Http\Middleware\ValidateCsrfToken::class]);

Route::post('/webhooks/bitgo', [BitGoWebhookController::class, 'handle'])
    ->withoutMiddleware([\Illuminate\Foundation\Http\Middleware\ValidateCsrfToken::class]);
