# 🏪 ToolStore - Telegram Bitcoin Digital Storefront

A complete **Telegram-first e-commerce platform** for selling digital products with Bitcoin payments, built with Laravel 12 and Filament 4.

## 🎯 Features

- 💬 **Telegram Bot Interface** - Full shopping experience in Telegram
- ₿ **Bitcoin Payments** - Accept BTC via BitGo, auto-convert to USD
- 🛍️ **Digital Products** - Instant delivery of downloads, keys, and content
- 🔐 **Secure & Idempotent** - No double-credits, transactional purchases
- 📊 **Admin Panel** - Filament 4 dashboard for complete management
- 📈 **Multi-Provider Rates** - Automatic fallback for BTC/USD pricing

## 🚀 Tech Stack

- **Framework**: Laravel 12
- **Admin Panel**: Filament 4
- **Database**: MySQL 8.0+
- **Cache/Queue**: Redis
- **Queue Monitor**: Laravel Horizon
- **Bitcoin**: BitGo SDK (neto737/bitgosdk-php)
- **QR Codes**: endroid/qr-code
- **Audit Trail**: spatie/laravel-activitylog

## ⚡ Quick Start

See **[SETUP.md](SETUP.md)** for complete installation instructions.

```bash
# 1. Install dependencies
composer install

# 2. Configure environment
cp .env.example .env
php artisan key:generate

# 3. Run migrations
php artisan migrate
php artisan db:seed

# 4. Start application
php artisan serve
```

## 📱 Telegram Bot Features

- `/start` - Main menu with inline keyboard
- Browse categories and products
- Create deposit requests with QR codes
- Check USD balance
- Purchase products instantly
- View purchase history
- Read terms and conditions

## 💰 How It Works

1. **User deposits BTC** → Unique address generated via BitGo
2. **BitGo confirms transaction** → USD credited at market rate
3. **User browses products** → Categories → Subcategories → Products
4. **User purchases** → Balance deducted, product details delivered instantly
5. **Admin manages** → Filament panel for products, orders, deposits

## 🔒 Security

- ✅ Webhook signature verification (BitGo HMAC, Telegram secret)
- ✅ Idempotent deposit crediting (prevents double-credits)
- ✅ Database transactions for all balance changes
- ✅ Precise money math with bcmath
- ✅ CSRF protection (exempt only for verified webhooks)

## 📂 Project Structure

```
app/
├── Http/Controllers/
│   ├── BotWebhookController.php      # Telegram bot handlers
│   └── BitGoWebhookController.php    # Bitcoin deposit processing
├── Models/                            # Eloquent models with relationships
├── Services/
│   ├── BitGoService.php              # BitGo SDK wrapper
│   ├── RateService.php               # Multi-provider BTC/USD rates
│   ├── QrService.php                 # QR code generation
│   └── TelegramService.php           # Telegram API helper
└── Filament/Resources/               # Admin panel resources

database/
├── migrations/                        # 10 database tables
└── seeders/                          # Admin user + sample data

routes/
└── web.php                           # Webhook routes (CSRF exempt)
```

## 🛠️ Configuration

### Required Environment Variables

```env
# BitGo
BITGO_API_KEY=your_api_key
BITGO_WALLET_ID=your_wallet_id
BITGO_WEBHOOK_SECRET=your_webhook_secret
BITGO_TESTNET=true
BITGO_REQUIRED_CONFIRMATIONS=2

# Telegram
TELEGRAM_BOT_TOKEN=your_bot_token
TELEGRAM_WEBHOOK_SECRET=your_secret

# Redis (for queues)
QUEUE_CONNECTION=redis
CACHE_DRIVER=redis
```

### Webhook Endpoints

- `POST /bot/webhook` - Telegram bot webhook
- `POST /webhooks/bitgo` - BitGo deposit notifications

### Admin Panel

- URL: `/admin`
- Default login: `admin@toolstore.com` / `password`

## 📊 Database Schema

- `users` - Telegram users with USD balance
- `categories` - Hierarchical product categories
- `products` - Digital products with instant delivery
- `deposit_requests` - Unique BTC addresses
- `deposits` - BTC transactions with confirmations
- `orders` - Purchase records
- `order_items` - Order line items

## 🧪 Testing

1. Set `BITGO_TESTNET=true` in `.env`
2. Use BitGo testnet wallet
3. Send testnet BTC to generated addresses
4. Monitor webhook responses
5. Test purchase flow with credited balance

## 📚 Documentation

- **[SETUP.md](SETUP.md)** - Complete setup guide
- **[.windsurf/product.md](.windsurf/product.md)** - Product specification
- **[.windsurf/development-plan.md](.windsurf/development-plan.md)** - Development roadmap

## 🎊 Status

**✅ PRODUCTION READY** - All core features implemented and tested.

### Completed Features
- ✅ Telegram bot with full shopping flow
- ✅ BitGo integration with idempotent crediting
- ✅ Multi-provider rate fetching with fallback
- ✅ Transactional purchase system
- ✅ Filament admin panel
- ✅ Queue monitoring with Horizon
- ✅ Comprehensive documentation

## 🤝 Support

For setup help or issues:
1. Review [SETUP.md](SETUP.md)
2. Check `storage/logs/laravel.log`
3. Verify webhook configurations
4. Test with BitGo testnet first

## License

The Laravel framework is open-sourced software licensed under the [MIT license](https://opensource.org/licenses/MIT).
