<?php

declare(strict_types=1);

use App\Actions\Telegram\ProcessStartCommand;
use App\Bot\Data\TelegramMessageData;
use App\Bot\Data\TelegramUserData;
use App\Bot\Data\TelegramChatData;
use App\Events\UserRegistered;
use App\Models\User;
use App\Services\TelegramService;
use Illuminate\Support\Facades\Event;

beforeEach(function () {
    $this->telegram = Mockery::mock(TelegramService::class);
});

it('creates a new user when processing start command', function () {
    Event::fake();
    
    $messageData = new TelegramMessageData(
        message_id: 123,
        chat: new TelegramChatData(id: 456, type: 'private'),
        from: new TelegramUserData(
            id: 789,
            first_name: 'John',
            username: 'johndoe'
        ),
        text: '/start'
    );

    $this->telegram->shouldReceive('createInlineKeyboard')->once()->andReturn([]);
    $this->telegram->shouldReceive('sendMessage')->once();

    $action = new ProcessStartCommand($this->telegram);
    $action->execute($messageData);

    expect(User::where('telegram_id', '789')->exists())->toBeTrue();
    Event::assertDispatched(UserRegistered::class);
});

it('does not emit event for existing user', function () {
    Event::fake();
    
    // Create user first
    User::create([
        'telegram_id' => '789',
        'name' => 'John',
        'username' => 'johndoe',
        'role' => 'user',
    ]);

    $messageData = new TelegramMessageData(
        message_id: 123,
        chat: new TelegramChatData(id: 456, type: 'private'),
        from: new TelegramUserData(
            id: 789,
            first_name: 'John',
            username: 'johndoe'
        ),
        text: '/start'
    );

    $this->telegram->shouldReceive('createInlineKeyboard')->once()->andReturn([]);
    $this->telegram->shouldReceive('sendMessage')->once();

    $action = new ProcessStartCommand($this->telegram);
    $action->execute($messageData);

    Event::assertNotDispatched(UserRegistered::class);
});
