<?php

declare(strict_types=1);

use App\Bot\Data\TelegramUpdateData;
use App\Bot\Data\TelegramMessageData;
use App\Bot\Data\TelegramUserData;
use App\Bot\Data\TelegramChatData;
use App\Jobs\HandleTelegramUpdate;
use App\Models\User;

it('routes start command to correct action', function () {
    $updateData = new TelegramUpdateData(
        update_id: 12345,
        message: new TelegramMessageData(
            message_id: 123,
            chat: new TelegramChatData(id: 456, type: 'private'),
            from: new TelegramUserData(
                id: 789,
                first_name: 'John',
                username: 'johndoe'
            ),
            text: '/start'
        )
    );

    $job = new HandleTelegramUpdate($updateData);
    $job->handle();

    expect(User::where('telegram_id', '789')->exists())->toBeTrue();
});

it('handles message without text gracefully', function () {
    $updateData = new TelegramUpdateData(
        update_id: 12345,
        message: new TelegramMessageData(
            message_id: 123,
            chat: new TelegramChatData(id: 456, type: 'private'),
            from: new TelegramUserData(
                id: 789,
                first_name: 'John',
                username: 'johndoe'
            ),
            text: null
        )
    );

    $job = new HandleTelegramUpdate($updateData);
    
    expect(fn() => $job->handle())->not->toThrow(Exception::class);
});
