<?php

use App\Actions\Telegram\ProcessBalanceCommand;
use App\Bot\Data\TelegramMessageData;
use App\Bot\Data\TelegramUserData;
use App\Bot\Data\TelegramChatData;
use App\Models\User;
use App\Services\TelegramService;

uses()->group('telegram');

beforeEach(function () {
    $this->artisan('migrate:fresh');
    
    $this->telegram = Mockery::mock(TelegramService::class);
    $this->app->instance(TelegramService::class, $this->telegram);
});

it('shows balance for existing user', function () {
    $user = User::create([
        'telegram_id' => '789',
        'name' => 'John',
        'username' => 'johndoe',
        'role' => 'user',
        'balance_usd' => 100.50,
    ]);

    $messageData = new TelegramMessageData(
        message_id: 123,
        chat: new TelegramChatData(id: 456, type: 'private'),
        from: new TelegramUserData(
            id: 789,
            firstName: 'John',
            username: 'johndoe'
        ),
        text: '/balance'
    );

    $this->telegram->shouldReceive('createInlineKeyboard')->once()->andReturn([]);
    $this->telegram->shouldReceive('sendMessage')
        ->once()
        ->with(456, Mockery::on(function ($text) {
            return str_contains($text, '$100.5');
        }), Mockery::any());

    $action = new ProcessBalanceCommand($this->telegram);
    $action->execute($messageData);
});

it('does nothing for non-existent user', function () {
    $messageData = new TelegramMessageData(
        message_id: 123,
        chat: new TelegramChatData(id: 456, type: 'private'),
        from: new TelegramUserData(
            id: 999,
            firstName: 'Unknown',
            username: 'unknown'
        ),
        text: '/balance'
    );

    $this->telegram->shouldReceive('createInlineKeyboard')->never();
    $this->telegram->shouldReceive('sendMessage')->never();

    $action = new ProcessBalanceCommand($this->telegram);
    $action->execute($messageData);

    expect(true)->toBeTrue();
});
