<?php

use App\Actions\Telegram\ProcessHelpCommand;
use App\Bot\Data\TelegramMessageData;
use App\Bot\Data\TelegramUserData;
use App\Bot\Data\TelegramChatData;
use App\Services\TelegramService;

uses()->group('telegram');

beforeEach(function () {
    $this->artisan('migrate:fresh');
    
    $this->telegram = Mockery::mock(TelegramService::class);
    $this->app->instance(TelegramService::class, $this->telegram);
});

it('shows help message with all commands', function () {
    $messageData = new TelegramMessageData(
        message_id: 123,
        chat: new TelegramChatData(id: 456, type: 'private'),
        from: new TelegramUserData(id: 789, firstName: 'John', username: 'johndoe'),
        text: '/help'
    );

    $this->telegram->shouldReceive('createInlineKeyboard')->once()->andReturn([]);
    $this->telegram->shouldReceive('sendMessage')
        ->once()
        ->with(456, Mockery::on(function ($text) {
            return str_contains($text, 'Help & Commands') &&
                   str_contains($text, '/start') &&
                   str_contains($text, '/balance') &&
                   str_contains($text, '/history') &&
                   str_contains($text, '/help');
        }), Mockery::any());

    $action = new ProcessHelpCommand($this->telegram);
    $action->execute($messageData);
});

it('includes how to use instructions', function () {
    $messageData = new TelegramMessageData(
        message_id: 123,
        chat: new TelegramChatData(id: 456, type: 'private'),
        from: new TelegramUserData(id: 789, firstName: 'John', username: 'johndoe'),
        text: '/help'
    );

    $this->telegram->shouldReceive('createInlineKeyboard')->once()->andReturn([]);
    $this->telegram->shouldReceive('sendMessage')
        ->once()
        ->with(456, Mockery::on(function ($text) {
            return str_contains($text, 'How to use') &&
                   str_contains($text, 'Deposit') &&
                   str_contains($text, 'Browse') &&
                   str_contains($text, 'Purchase');
        }), Mockery::any());

    $action = new ProcessHelpCommand($this->telegram);
    $action->execute($messageData);
});
